% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isgd_links.R
\name{isgd_LinksShorten}
\alias{isgd_LinksShorten}
\title{Given a long URL, returns a short is.gd link.}
\usage{
isgd_LinksShorten(
  longUrl = "",
  logstats = "0",
  shorturl = NULL,
  showRequestURL = FALSE
)
}
\arguments{
\item{longUrl}{- The url parameter is the address that you want to shorten.}

\item{logstats}{- (optional) Adding the parameter logstats=1 turns on logging of detailed
statistics when the shortened URL you create is accessed. This allows you to see how many
times the link was accessed on a given day, what pages referred people to the link, what
browser visitors were using etc. You can access these stats via the link preview page for
your shortened URL (add a hyphen/dash to the end of the shortened URL to get to it). Creating
links with statistics turned on has twice the "cost" towards our rate limit of other shortened
links, so leave this parameter out of your API call if you don't require statistics on usage. See
our usage limits page for more information on this \url{https://is.gd/usagelimits.php}.}

\item{shorturl}{- (optional) You can specify the shorturl parameter if you'd like to pick a
shortened URL instead of having is.gd randomly generate one. These must be between
5 and 30 characters long and can only contain alphanumeric characters and underscores.
Shortened URLs are case sensitive. Bear in mind that a desired short URL might already
be taken (this is very often the case with common words) so if you're using this option
be prepared to respond to an error and get an alternative choice from your app's user.}

\item{showRequestURL}{- show URL which has been build and requested from server.
For debug purposes.}
}
\description{
See \url{https://is.gd/apishorteningreference.php}
}
\examples{
\dontrun{
short_lin <- isgd_LinksShorten(longUrl = "https://novinky.cz/",showRequestURL = TRUE)
}
}
