% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/long_format.R
\name{pivot_to_numeric_matrix}
\alias{pivot_to_numeric_matrix}
\title{Convert a data frame in long format to a numeric matrix}
\usage{
pivot_to_numeric_matrix(data, obs_col, feature_col, value_col)
}
\arguments{
\item{data}{A data frame with numerical values in long format.}

\item{obs_col}{The column listing the observation, or row of the matrix.}

\item{feature_col}{The column listing the feature, or column of the matrix.}

\item{value_col}{The column listing the value, to be placed inside the
  matrix.

The parameters \code{obs_col}, \code{feature_col}, and \code{value_col}
should be provided as bare column names. If any combination of row and
column does not appear in the data frame, a zero will be entered in the
resultant matrix.

This function requires the packages \code{dplyr}, \code{tibble}, and
\code{tidyr} to be installed. If they are not installed, the function will
generate an error, with a message to install the appropriate packages.}
}
\description{
Convert a data frame in long format to a numeric matrix
}
\examples{
longdata <- data.frame(
  SampleID = paste0("Sample", c(1, 1, 1, 2, 2, 3, 3)),
  FeatureID = paste0("Feature", c(1, 2, 3, 1, 2, 2, 3)),
  Value = c(132, 41, 7, 56, 11, 929, 83))
longdata
pivot_to_numeric_matrix(longdata, SampleID, FeatureID, Value)
}
