% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hartigan.r
\name{ComputeHartigan}
\alias{ComputeHartigan}
\title{Compute Hartigan's Number}
\usage{
ComputeHartigan(FitActualWSS, FitPlus1WSS, nrow)
}
\arguments{
\item{FitActualWSS}{the WSS from a kmeans fit}

\item{FitPlus1WSS}{the WSS from a kmeans fit}

\item{nrow}{the number of rows in the original dataset}
}
\value{
The computed Hartigan Number
}
\description{
Runs the computation found in http://www.stat.columbia.edu/~madigan/DM08/descriptive.ppt.pdf
}
\details{
Not exported, only used by \code{\link{FitKMeans}}
}
\examples{
data(iris)
hartiganResults <- FitKMeans(iris[, -ncol(iris)])
PlotHartigan(hartiganResults)

}
\references{
http://www.stat.columbia.edu/~madigan/DM08/descriptive.ppt.pdf
}
\seealso{
\code{\link{kmeans}} \code{\link{FitKMeans}}
}
\author{
Jared P. Lander
www.jaredlander.com
}
\keyword{cluster}
\keyword{clustering}
\keyword{hartigan}
\keyword{kmeans}
