% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{get_common_values}
\alias{get_common_values}
\title{Get the common values of two vectors}
\usage{
get_common_values(vec1, vec2, vector.values.str = "nodes",
  with.gt = TRUE)
}
\arguments{
\item{vec1}{vector}

\item{vec2}{vector}

\item{vector.values.str}{string. Used for printing, it tell us what are the
values of the two vectors (use plural form). Default value: "nodes".}

\item{with.gt}{logical. Determines if the ">" sign will be appended for nice
printing in an R notebook. Default value: TRUE.}
}
\value{
the vector of the common values. If there is only one value
in common, the \code{vector.values.str} gets the last character stripped for
readability. If there are no common values, it returns NULL.
}
\description{
This function prints and returns the common values of two vectors. The two
vectors don't have to be the same length.
}
\examples{
vec1 = c(1,2,3)
vec2 = c(3,4,1)

common.names = get_common_values(vec1, vec2)

}
\seealso{
\code{\link{pretty_print_vector_values}}, \code{\link{pretty_print_string}}
}
