% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyverse.R
\name{tidyverse}
\alias{tidyverse}
\alias{use_tidy_ci}
\alias{use_tidy_description}
\alias{use_tidy_versions}
\alias{use_tidy_eval}
\alias{use_tidy_contributing}
\alias{use_tidy_issue_template}
\alias{use_tidy_support}
\alias{use_tidy_coc}
\alias{use_tidy_github}
\alias{use_tidy_style}
\title{Helpers for the tidyverse}
\usage{
use_tidy_ci(browse = interactive())

use_tidy_description()

use_tidy_versions(overwrite = FALSE)

use_tidy_eval()

use_tidy_contributing()

use_tidy_issue_template()

use_tidy_support()

use_tidy_coc()

use_tidy_github()

use_tidy_style(strict = TRUE)
}
\arguments{
\item{browse}{Open a browser window to enable automatic builds for the
package.}

\item{overwrite}{By default (\code{FALSE}), only dependencies without version
specifications will be modified. Set to \code{TRUE} to modify all dependencies.}

\item{strict}{Boolean indicating whether or not a strict version of styling
should be applied. See \code{\link[styler:tidyverse_style]{styler::tidyverse_style()}} for details.}
}
\description{
These helpers follow tidyverse conventions which are generally a little
stricter than the defaults, reflecting the need for greater rigor in
commonly used packages.
}
\details{
\itemize{
\item \code{use_tidy_ci()}: sets up travis and codecov, ensuring that the package
works on all versions of R starting at 3.1.
\item \code{use_tidy_description()}: puts fields in standard order and alphabetises
dependencies.
\item \code{use_tidy_eval()}: imports a standard set of helpers to facilitate
programming with the tidy eval toolkit.
\item \code{use_tidy_style()}: styles source code according to the \href{http://style.tidyverse.org}{tidyverse style guide}. This function will overwrite files! See
below for usage advice.
\item \code{use_tidy_versions()}: pins all dependencies to require at least
the currently installed version.
\item \code{use_tidy_contributing()}: adds standard tidyverse contributing guidelines.
\item \code{use_tidy_issue_template()}: adds a standard tidyverse issue template.
\item \code{use_tidy_support()}: adds a standard description of support resources for
the tidyverse.
\item \code{use_tidy_coc()}: equivalent to \code{use_code_of_conduct()}, but puts the
document in a \code{.github/} subdirectory.
\item \code{use_tidy_github()}: convenience wrapper that calls
\code{use_tidy_contributing()}, \code{use_tidy_issue_template()}, \code{use_tidy_support()},
\code{use_tidy_coc()}.
}
}
\section{\code{use_tidy_style()}}{

Uses the \href{http://styler.r-lib.org}{styler package} package to style all code
in a package, project, or directory, according to the \href{http://style.tidyverse.org}{tidyverse style guide}.

\strong{Warning:} This function will overwrite files! It is strongly suggested to
only style files that are under version control or to first create a backup
copy.

Invisibly returns a data frame with one row per file, that indicates whether
styling caused a change.
}

