% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fips.R
\name{fips_info}
\alias{fips_info}
\alias{fips_info.numeric}
\alias{fips_info.character}
\title{Retrieve states or counties using FIPS codes}
\usage{
fips_info(fips)

\method{fips_info}{numeric}(fips)

\method{fips_info}{character}(fips)
}
\arguments{
\item{fips}{A one to five digit, either \code{numeric}
or \code{character}, vector of FIPS codes for which to look up states or counties.
States have a two digit FIPS code and counties have a five digit FIPS
code (where the first 2 numbers pertain to the state).}
}
\value{
A data frame with the states or counties and the associated
 FIPS codes.
}
\description{
Retrieve states or counties using FIPS codes
}
\examples{
fips_info(2)
fips_info("2")
fips_info(c("02", "03", "04"))

fips_info(2016)
fips_info(c("02016", "02017"))

}
