% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paste.R
\name{paste_freq}
\alias{paste_freq}
\title{paste_freq}
\usage{
paste_freq(count, total, percent.sign, remove.na, digits)
}
\arguments{
\item{count}{Required. Tibble, Column (logical), or Numeric. The numerator.
Tibbles and columns are automatically tallied (nrow or sum(na.rm = TRUE)).}

\item{total}{Required. Tibble, Column, or Numeric. The denominator. Tibbles
and columns are automatically tallied (nrow or sum(na.rm = TRUE)).}

\item{percent.sign}{Optional. Logical. Indicates percent sign should be printed
for frequencies. Defaults to TRUE.}

\item{remove.na}{Optional. Logical. Remove NA from denominator in frequency calculation.
Defaults to TRUE.}

\item{digits}{Optional. Integer. Number of digits to round to. Defaults to 1.}
}
\description{
Returns a human-readable frequency from count(able) data. Handily
has methods for several types of data.
}
\examples{
library(tibble)

# Numeric
paste_freq(20, 100)

# Logical
data_logical <- tribble(
  ~numerator, ~denomenator,
  TRUE, TRUE,
  FALSE, TRUE,
  FALSE, TRUE
)
paste_freq(data_logical$numerator, data_logical$denomenator)

# Tibble
data_tibble <- tibble(column = c(1:100))
paste_freq(data_tibble[1:20,], data_tibble)
}
