% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq5d.R
\name{eq5dmap5Lto3LIndscores}
\alias{eq5dmap5Lto3LIndscores}
\title{Function to map EQ-5D-5L descriptive system to 3L index value}
\usage{
eq5dmap5Lto3LIndscores(country = "UK", method = "CW", this.response,
  this.response2 = NA, this.response3 = NA, this.response4 = NA,
  this.response5 = NA)
}
\arguments{
\item{country}{default is "UK"}

\item{method}{CW cross walk}

\item{this.response}{response for EQ-5D-5L mobility  or the 5 digit response, or the vector of responses, e.g. 11111, c(1,1,1,1,1) or 1}

\item{this.response2}{response for EQ-5D-5L self care, or NA if the responses are given as this.response}

\item{this.response3}{response for EQ-5D-5L usual activities,or NA if the responses are given as this.response}

\item{this.response4}{response for EQ-5D-5L pain/discomfort, or NA if the responses are given as this.response}

\item{this.response5}{response for EQ-5D-5L anxiety/depression, or NA if the responses are given as this.response}
}
\value{
index value of EQ-5D-3L, -1 if any error
}
\description{
Function to map EQ-5D-5L descriptive system to 3L index value (ref:Van Hout et al 2012 and code inspired from https://github.com/brechtdv/eq5d-mapping)
}
\examples{
eq5dmap5Lto3LIndscores("UK","CW",11125)
eq5dmap5Lto3LIndscores("UK","CW",c(1,1,1,2,5))
eq5dmap5Lto3LIndscores("UK","CW",1,1,1,2,5)
}
