% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empirical_comparison.R
\name{severity_ribbon_plot}
\alias{severity_ribbon_plot}
\title{severity_ribbon_plot}
\usage{
severity_ribbon_plot(
  df,
  utility_columns,
  weight_column = "VAS",
  weight_range = c(0:100),
  weight_values = NULL,
  weight_function = .makeWeightsMixed,
  sample_size = 1000,
  number_of_samples = 1000,
  probability_levels = c(min = 0, `2.5\%` = 0.025, `25\%` = 0.25, median = 0.5, `75\%` =
    0.75, `97.5\%` = 0.975, max = 1),
  graph_title = "",
  x_axis_title = "",
  y_axis_title = "",
  legend_name = "Type",
  legend_labels = NULL,
  y_axis_limits = c(0.15, 0.95),
  y_min_value = "2.5\%",
  y_max_value = "97.5\%",
  alpha_1 = 0.15,
  alpha_2 = 0.05,
  linetype_1 = 1,
  linetype_2 = 2,
  interpretation_quartiles = c(0, 0.25, 0.5, 0.75, 1),
  elevation_threshold = 0.05,
  slope_threshold = 0.02,
  color_palette = NULL,
  weighted_statistics = NULL
)
}
\arguments{
\item{df}{A data frame containing the utility and weight columns.}

\item{utility_columns}{A character vector specifying the utility columns for which the ribbon plot will be generated.}

\item{weight_column}{A string specifying the column that contains the weights. Default is "VAS".}

\item{weight_range}{A numeric vector specifying the range of weights. Default is c(0:100).}

\item{weight_values}{A numeric vector specifying the weight values to be used. Default is NULL, in which case the weight_range will be used.}

\item{weight_function}{A function to generate weights. Default is .makeWeightsMixed.}

\item{sample_size}{An integer specifying the sample size for bootstrapping. Default is 1000.}

\item{number_of_samples}{An integer specifying the number of bootstrap samples. Default is 1000.}

\item{probability_levels}{A named vector specifying the probability levels for quantile.}

\item{graph_title}{A string specifying the title of the graph. Default is an empty string.}

\item{x_axis_title}{A string specifying the title for the x-axis. Default is an empty string.}

\item{y_axis_title}{A string specifying the title for the y-axis. Default is an empty string.}

\item{legend_name}{A string specifying the name for the legend. Default is "Type".}

\item{legend_labels}{A character vector specifying the labels for the legend. Default is NULL.}

\item{y_axis_limits}{A numeric vector specifying the limits for the y-axis. Default is c(0.15, 0.95).}

\item{y_min_value}{A string specifying the minimum value for the y-axis.}

\item{y_max_value}{A string specifying the maximum value for the y-axis.}

\item{alpha_1}{A numeric value between 0 and 1 to define the transparency of the interquartile range. Default is 0.15.}

\item{alpha_2}{A numeric value between 0 and 1 to define the transparency of the confidence interval range. Default is 0.05.}

\item{linetype_1}{A numeric value between 0 and 1 to define the line type of the interquartile range. Default is 1 "solid".}

\item{linetype_2}{A numeric value between 0 and 1 to define the line type of the confidence interval range. Default 2 "dashed".}

\item{interpretation_quartiles}{A numeric vector of values between 0 and 1 to define the quantile ranges for the figure interpretation. Default is c(0, 0.25, 0.5, 0.75, 1)}

\item{elevation_threshold}{A numeric value specifying the threshold for elevation differences. Default is 0.05.}

\item{slope_threshold}{A numeric value specifying the threshold for slope differences. Default is 0.02.}

\item{color_palette}{A character vector specifying the color palette for the plot. Default is c("#8dd3c7", "#bebada", "#80b1d3", "#fb8072", "#ffff67", "#fdb462", "#b3de69", "#fccde5", "#d9d9d9", "#bc80bd").}

\item{weighted_statistics}{An optional data frame of pre-computed weighted statistics. Default is NULL.}
}
\value{
A list containing three elements: 'df' which is a data frame of weighted statistics, 'plot' which is the ggplot object representing the ribbon plot and 'interpretation' with the automatic interpretation of the ribbon plot.
}
\description{
This function generates a ribbon plot for given utility columns, based on weighted statistics.
}
\examples{
\donttest{
  # Define dimension names for EQ-5D-3L and EQ-5D-5L
  dim.names.3L <- c("mobility", "selfcare", "activity", "pain", "anxiety")
  dim.names.5L <- c("mobility5L", "selfcare5L", "activity5L", "pain5L", "anxiety5L")
  # Compute EQ-5D scores using the eq5dsuite package
  cdta$EQ5D3L <- eq5dsuite::eq5d3l(x = cdta,
                                   country = "US", 
                                   dim.names = dim.names.3L)
  cdta$EQ5D5L <- eq5dsuite::eq5d5l(x = cdta, 
                                   country = "US", 
                                   dim.names = dim.names.5L)
  cdta$EQXW <- eq5dsuite::eqxw(x = cdta, 
                               country = "US", 
                               dim.names = dim.names.5L)
  # Get severity ribbon plot
  result <- severity_ribbon_plot(df = cdta, utility_columns = c("EQ5D3L", "EQ5D5L", "EQXW"))
}
}
