#' Well-Being and Basic Needs Survey, 2019 (Individual-Level)
#'
#' This subset of data comes from one iteration of the \emph{Well-Being and Basic Needs Survey}, administered in 2019. These data were collected by the Urban Institute. Information about the data set can be found in the WBBN2019 Codebook at: \url{https://burrelvannjr.com/docs/WBBN2019_Codebook.pdf}.
#'
#' @format A data frame with 7694 observations and 23 variables.
#' \tabular{ll}{ \cr
#' subsidized_housing \tab Is your household paying lower rent because the federal, state, or local government is paying part of the cost? \cr
#' food_last \tab Food did not last \cr
#' nervous \tab During the past 30 days, about how often did you feel: nervous? \cr
#' hopeless \tab During the past 30 days, about how often did you feel: hopeless? \cr
#' restless \tab During the past 30 days, about how often did you feel: restless or fidgety? \cr
#' no_cheer \tab During the past 30 days, about how often did you feel: so sad that nothing could cheer you up \cr
#' worthless \tab During the past 30 days, about how often did you feel: worthless? \cr
#' insured \tab Thinking about your health insurance coverage over the past 12 months, how many months were you insured? \cr
#' med_notafford \tab Thinking about your health care experiences over the past 12 months, was there any time when you needed medical care but did not get it because you couldn't afford it? \cr
#' working \tab Are you currently working for pay or self-employed? \cr
#' unexp_400 \tab How confident are you that you could come up with $400 if an unexpected expense arose within the next month? \cr
#' educ \tab Education level \cr
#' race_eth \tab Race/ethnicity \cr
#' sex_gender \tab Sex/Gender \cr
#' head_household \tab Head of Household? \cr
#' internet \tab Internet access \cr
#' children_in_house \tab Number of children age 0-18 in household \cr
#' food_insecure \tab Household was food insecure in past 12 months \cr
#' utility_suspend \tab Gas or electric company turned off service or oil company would not deliver in oil past 12 months \cr
#' utility_problems_paying \tab Household was not able to pay full amount of gas, oil, or electricity bills in past 12 months \cr
#' mortgage_cost \tab How much is the regular monthly payment on this property, including mortgage payments, second mortgage or home equity loan payments, real estate taxes, insurance, and condominium fees? \cr
#' rent_cost \tab What is the monthly rent for the place where you live? \cr
#' electricity_cost \tab In a typical month, what is the total cost of electricity, gas, and any other fuel used in the place where you live? \cr
#' }
#' @source Data: \url{https://www.icpsr.umich.edu/web/ICPSR/studies/38044}
#' @source Codebook: \url{https://burrelvannjr.com/docs/WBBN2019_Codebook.pdf}

#'
"WBBN2019"
