\name{serial}

\alias{serial}

\title{Test for serially correlated errors}

\encoding{latin1}

\description{
  This function computes the multivariate Portmanteau- and Breusch-Godfrey
  test for serially correlated errors.
}

\usage{
serial(x, lags.pt = 16, lags.bg = 5, type = c("PT.asymptotic",
"PT.adjusted", "BG", "ES") )
}

\arguments{
  \item{x}{Object of class \sQuote{\code{varest}}; generated by
    \command{VAR()}, or an object of class \sQuote{\code{vec2var}};
    generated by \command{vec2var()}.}  
  \item{lags.pt}{An integer specifying the lags to be used for the
    Portmanteau statistic.}
  \item{lags.bg}{An integer specifying the lags to be used for the
    Breusch-Godfrey statistic.}
  \item{type}{Character, the type of test. The default is an asymptotic
    Portmanteau test.}
}

\details{
  The Portmanteau statistic for testing the absence of up to the order \eqn{h}
  serially correlated disturbances in a stable VAR(p) is defined as:
  \deqn{
    Q_h = T \sum_{j = 1}^h
    tr(\hat{C}_j'\hat{C}_0^{-1}\hat{C}_j\hat{C}_0^{-1}) \quad ,
  }
  where \eqn{\hat{C}_i = \frac{1}{T}\sum_{t = i + 1}^T \bold{\hat{u}}_t
    \bold{\hat{u}}_{t - i}'}. The test statistic is approximately
  distributed as \eqn{\chi^2(K^2(h - p))}. This test statistic is
  choosen by setting \code{type = "PT.asymptotic"}. For smaller sample sizes
  and/or values of \eqn{h} that are not sufficiently large, a corrected
  test statistic is computed as:
  \deqn{
    Q_h^* = T^2 \sum_{j = 1}^h
    \frac{1}{T - j}tr(\hat{C}_j'\hat{C}_0^{-1}\hat{C}_j\hat{C}_0^{-1}) \quad ,
  }
  This test statistic can be accessed, if \code{type = "PT.adjusted"} is
  set.\cr  

  The Breusch-Godfrey LM-statistic is based upon the following auxiliary
  regressions:
  \deqn{
    \bold{\hat{u}}_t = A_1 \bold{y}_{t-1} + \ldots + A_p\bold{y}_{t-p} +
    CD_t + B_1\bold{\hat{u}}_{t-1} + \ldots + B_h\bold{\hat{u}}_{t-h} +
    \bold{\varepsilon}_t   
  }
  The null hypothesis is: \eqn{H_0: B_1 = \ldots = B_h = 0} and
  correspondingly the alternative hypothesis is of the form \eqn{H_1:
    \exists \; B_i \ne 0} for \eqn{i = 1, 2, \ldots, h}. The test statistic
  is defined as:

  \deqn{
    LM_h = T(K - tr(\tilde{\Sigma}_R^{-1}\tilde{\Sigma}_e))  \quad ,
  }
  where \eqn{\tilde{\Sigma}_R} and \eqn{\tilde{\Sigma}_e} assign the
  residual covariance matrix of the restricted and unrestricted
  model, respectively. The test statistic \eqn{LM_h} is distributed as
  \eqn{\chi^2(hK^2)}. This test statistic is calculated if \code{type =
    "BG"} is used.\cr
  
  Edgerton and Shukur (1999) proposed a small sample correction, which
  is defined as:
  \deqn{
    LMF_h = \frac{1 - (1 - R_r^2)^{1/r}}{(1 - R_r^2)^{1/r}} \frac{Nr -
      q}{K m} \quad ,
  }
  with \eqn{R_r^2 = 1 - |\tilde{\Sigma}_e | / |\tilde{\Sigma}_R|},
  \eqn{r = ((K^2m^2 - 4)/(K^2 + m^2 - 5))^{1/2}}, \eqn{q = 1/2 K m - 1}
  and \eqn{N = T - K - m - 1/2(K - m + 1)}, whereby \eqn{n} is the
  number of regressors in the original system and \eqn{m = Kh}. The
  modified test statistic is distributed as \eqn{F(hK^2, int(Nr -
    q))}. This modified statistic will be returned, if \code{type =
    "ES"} is provided in the call to \code{serial()}.    
}

\value{
  A list with class attribute \sQuote{\code{varcheck}} holding the
  following elements:\cr

  \item{resid}{A matrix with the residuals of the VAR.}
  \item{pt.mul}{A list with objects of class attribute \sQuote{\code{htest}}
    containing the multivariate Portmanteau-statistic (asymptotic and
    adjusted.}
  \item{LMh}{An object with class attribute \sQuote{\code{htest}}
    containing the Breusch-Godfrey LM-statistic.}
  \item{LMFh}{An object with class attribute \sQuote{\code{htest}}
    containing the Edgerton-Shukur F-statistic.}  
}

\author{Bernhard Pfaff}

\references{
  Breusch, T . S. (1978), Testing for autocorrelation in dynamic linear
  models, \emph{Australian Economic Papers}, \bold{17}: 334-355.
  
  Edgerton, D. and Shukur, G. (1999), Testing autocorrelation in a
  system perspective, \emph{Econometric Reviews}, \bold{18}: 43-386.

  Godfrey, L. G. (1978), Testing for higher order serial correlation in
  regression equations when the regressors include lagged dependent
  variables, \emph{Econometrica}, \bold{46}: 1303-1313.
  
  Hamilton, J. (1994), \emph{Time Series Analysis}, Princeton
  University Press, Princeton.

  Ltkepohl, H. (2006), \emph{New Introduction to Multiple Time Series
    Analysis}, Springer, New York.
}

\seealso{
  \code{\link{VAR}}, \code{\link{vec2var}}, \code{\link{plot}}
}

\examples{
data(Canada)
var.2c <- VAR(Canada, p = 2, type = "const")
serial(var.2c, lags.pt = 16, type = "PT.adjusted")
}

\keyword{regression}
\concept{VAR}
\concept{VECM}
\concept{Vector autoregressive model}
\concept{Portmanteau}
\concept{Breusch Godfrey}
\concept{Serial Correlation}
\concept{Serially correlated errors}



