\name{logLik}

\alias{logLik}

\alias{logLik.varest}

\alias{logLik.vec2var}

\alias{logLik.svarest}

\encoding{latin1}

\title{Log-Likelihood method}

\description{
  Returns the log-Likelihood of a VAR, level-VECM or SVAR object.
}

\usage{
\method{logLik}{varest}(object, ...)
\method{logLik}{vec2var}(object, ...)
\method{logLik}{svarest}(object, ...)
}
\arguments{
  \item{object}{An object of class \sQuote{\code{varest}}, generated by
    \command{VAR()}; or an object of class \sQuote{\code{vec2var}},
    generated by \command{vec2var()}; or an object of class
    \sQuote{\code{svarest}}, generated by either \command{SVAR()} or
    \command{SVAR2()}.}  
  \item{\dots}{Currently not used.}
}
\details{
  The log-likelihood of a VAR or level-VECM model is defined as:
  \deqn{
    \log l = - \frac{K T}{2} \log 2 \pi - \frac{T}{2} |\Sigma_u| -
    \frac{1}{2} tr (U \Sigma^{-1}_u U')
  }
  and for a SVAR-model the log-likelihood takes the form of:
  \deqn{
    \log l = - \frac{K T}{2} \log 2 \pi + \frac{T}{2} \log |A|^2 -
    \frac{T}{2} \log |B|^2 - \frac{T}{2} tr (A'B'^{-1}B^{-1}A\Sigma_u)
    }
}

\value{
  An object with class attribute \code{logLik}.  
}

\author{Bernhard Pfaff}

\references{
  Hamilton, J. (1994), \emph{Time Series Analysis}, Princeton
  University Press, Princeton.

  Ltkepohl, H. (2006), \emph{New Introduction to Multiple Time Series
    Analysis}, Springer, New York.  
}

\seealso{
  \code{\link{VAR}}, \code{\link{vec2var}}, \code{\link{SVAR}} 
} 

\examples{
data(Canada)
var.2c <- VAR(Canada, p = 2, type = "const")
logLik(var.2c) 
}

\keyword{regression}
\concept{VAR}
\concept{VECM}
\concept{Vector autoregressive}
\concept{Forecasts of VAR}
\concept{Prediction of VAR}
\concept{logLik}
