% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{masplit}
\alias{masplit}
\title{masplit}
\usage{
masplit(myMat, delim = ",", count = 0L, record = 1L, sort = 1L,
  decreasing = 1L)
}
\arguments{
\item{myMat}{a matrix of delimited strings (e.g., "7,2").}

\item{delim}{character that delimits values.}

\item{count}{return the count of delimited records.}

\item{record}{which (1-based) record to return.}

\item{sort}{should the records be sorted prior to selecting the element (0,1)?}

\item{decreasing}{should the values be sorted decreasing (1) or increasing (0)?}
}
\value{
A numeric matrix
}
\description{
Split a matrix of delimited strings.
}
\details{
Split a matrix of delimited strings that represent numerics into numerics.
The parameter \strong{count} returns a matrix of integers indicating how many delimited records exist in each element.
This is intended to help if you do not know how many records are in each element particularly if there is a mixture of numbers of records.
The parameter \strong{record} indicates which record to return (first, second, third, ...).
The parameter \strong{sort} indicates whether the records in each element should be sorted (1) or not (0) prior to selection.
When sorting has been selected \strong{decreasing} indicates if the sorting should be performed in a decreasing (1) or increasing (0) manner prior to selection.
}
\examples{
set.seed(999)
x1 <- round(rnorm(n=9, mean=10, sd=2))
x2 <- round(rnorm(n=9, mean=20, sd=2))
ad <- matrix(paste(x1, x2, sep=","), nrow=3, ncol=3)
colnames(ad) <- paste('Sample', 1:3, sep="_")
rownames(ad) <- paste('Variant', 1:3, sep="_")
ad[1,1] <- "9,23,12"
is.na(ad[3,1]) <- TRUE

ad
masplit(ad, count = 1)
masplit(ad, sort = 0)
masplit(ad, sort = 0, record = 2)
masplit(ad, sort = 0, record = 3)
masplit(ad, sort = 1, decreasing = 0)


}
