% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request_response.R
\name{request_response}
\alias{request_response}
\alias{request_summary}
\alias{response_summary}
\title{request and response summary methods}
\usage{
request_summary(request, request_matchers = "")

response_summary(response)
}
\arguments{
\item{request}{a \link{Request} object}

\item{request_matchers}{(character) a vector of matchers.
Default: \code{""}}

\item{response}{a \link{VcrResponse} object}
}
\value{
character string, of either request or response
}
\description{
request and response summary methods
}
\details{
By default, method and uri are included
in the request summary - if body and/or headers are
specified in \code{request_matchers}, then they are also
included

HTTP status code and response body are included in the
response summary. The response body is truncated to a
max of 80 characters
}
\examples{
# request
url <- "https://httpbin.org"
body <- list(foo = "bar")
headers <- list(
  `User-Agent` = "r-curl/3.2",
  `Accept-Encoding` = "gzip, deflate",
  Accept = "application/json"
)

(x <- Request$new("POST", url, body, headers))
request_summary(request = x)
request_summary(request = x, c('method', 'uri'))
request_summary(request = x, c('method', 'uri', 'body'))
request_summary(request = x, c('method', 'uri', 'headers'))
request_summary(request = x, c('method', 'uri', 'body', 'headers'))

# response
status <- list(status_code = 200, message = "OK",
  explanation = "Request fulfilled, document follows")
headers <- list(
  status = "HTTP/1.1 200 OK",
  connection = "keep-alive",
  date = "Tue, 24 Apr 2018 04:46:56 GMT"
)
response_body <- "{\\"args\\": {\\"q\\": \\"stuff\\"}, \\"headers\\": {\\"Accept\\": \\"application/json\\"}}\\n"
(x <- VcrResponse$new(status, headers,
   response_body, "HTTP/1.1 200 OK"))
response_summary(x)
}
\keyword{internal}
