% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightswitch.R
\name{lightswitch}
\alias{lightswitch}
\alias{turned_off}
\alias{turn_on}
\alias{turned_on}
\alias{turn_off}
\title{Turn vcr on and off, check on/off status, and turn off for a given http call}
\usage{
turned_off(..., ignore_cassettes = FALSE)

turn_on()

turned_on()

turn_off(ignore_cassettes = FALSE)
}
\arguments{
\item{...}{Any block of code to run, presumably an http request}

\item{ignore_cassettes}{(logical) Controls what happens when a cassette is
inserted while vcr is turned off. If \code{TRUE} is passed, the cassette
insertion will be ignored; otherwise an error will be raised.
Default: \code{FALSE}}
}
\description{
Turn vcr on and off, check on/off status, and turn off for a given http call
}
\details{
\itemize{
\item \code{turned_off()} - Turns vcr off for the duration of a block.
\item \code{turn_off()} - Turns vcr off, so that it no longer handles every
HTTP request
\item \code{turn_on()} - turns vcr on
\item \code{turned_on()} - Asks if vcr is turned on, gives a boolean
}

To turn vcr off completely, for example, if you are using vcr in your
package, but you want to run real HTTP requests in your tests, there are
a few options:
\itemize{
\item Run \code{turn_off(ignore_cassettes = TRUE)} before running tests. You can
do this on the command line e.g.,
\verb{Rscript -e 'vcr::turn_off(TRUE); devtools::test()'}, or within a running
R session the same way.
\item Set an environment variable \code{VCR_TURN_OFF=TRUE}.
You can do this on the command line by setting the env var at the beginning
of the line like: \verb{VCR_TURN_OFF=TRUE Rscript -e 'devtools::test()'}. Same
can be done within an interactive R session. You can also use this approach
to turn on or off vcr in CI builds like on Travis or Appveyor by setting
this env var in your Travis/Appveyor configuration file or in the settings
windows in the respective web apps
}

The full set of environment variables \code{vcr} uses, all of which accept only
\code{TRUE} or \code{FALSE}:
\itemize{
\item \code{VCR_TURN_OFF}: turn off vcr altogether; set to \code{TRUE} to skip any vcr
usage; default: \code{FALSE}
\item \code{VCR_TURNED_OFF}: set the \code{turned_off} internal package setting; this
does not turn off vcr completely as does \code{VCR_TURN_OFF} does, but rather
is looked at together with \code{VCR_IGNORE_CASSETTES}
\item \code{VCR_IGNORE_CASSETTES}: set the \code{ignore_cassettes} internal package
setting; this is looked at together with \code{VCR_TURNED_OFF}
}

See the HTTP testing book for more details
https://books.ropensci.org/http-testing/lightswitch.html

See \code{?Startup} if you're not sure how to set environment variables
}
\examples{
\dontrun{
vcr_configure(dir = tempdir())

turn_on()
turned_on()
turn_off()

# turn off for duration of a block
library(crul)
turned_off({
 res <- HttpClient$new(url = "https://eu.httpbin.org/get")$get()
})
res

# turn completely off
turn_off()
library(webmockr)
crul::mock()
# HttpClient$new(url = "https://eu.httpbin.org/get")$get(verbose = TRUE)
turn_on()
}
}
