% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eigen.test.R
\name{eigen.test}
\alias{eigen.test}
\title{Difference test for successive relative eigenvalues}
\usage{
eigen.test(n, relValues)
}
\arguments{
\item{n}{the sample size(s), given as a number or a vector of length 2}

\item{relValues}{a vector of relative eigenvalues}
}
\value{
The P-values for the test of difference between successive eigenvalues
}
\description{
Tests the difference between two successive relative eigenvalues
}
\examples{

# Data matrix of 2D landmark coordinates
data("Tropheus")
PHEN <- as.matrix(Tropheus[which(names(Tropheus) == "X1"):which(names(Tropheus) == "Y19")])

# Procrustes superimposition
library("geomorph")
PHEN_array <- arrayspecs(PHEN, p = 19, k = 2)
phen.gpa <- gpagen(PHEN_array, print.progress = FALSE)
proc.coord <- two.d.array(phen.gpa$coords)

# Data reduction
phen.pca <- prcomp(proc.coord, rank. = 5, tol = sqrt(.Machine$double.eps))
pc.scores <- phen.pca$x

# Covariance matrix of each population
S.phen.pop <- cov.group(pc.scores, groups = Tropheus$POP.ID)

# Relative PCA = relative eigenanalysis between 2 covariance matrices
# (population IKA1 relative to IKS5)
relEigen.a1s5 <- relative.eigen(S.phen.pop[, , "IKA1"], S.phen.pop[, , "IKS5"])

# Test of the difference between 2 successives eigenvalues
# of the covariance matrix of IKA1 relative to IKS5
eigen.test(n = c(71, 75), relValues = relEigen.a1s5$relValues)  # 71 and 75 are the sample sizes

}
\references{
Mardia KV, Kent JT, Bibby JM (1979)
\emph{Multivariate analysis}. Academic Press, London.
}
\seealso{
\code{\link{relative.eigen}} for the computation of relative eigenvalues,

\code{\link[stats]{pchisq}} for Chi-squared distribution
}
