% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emis_hot_td.R
\name{emis_hot_td}
\alias{emis_hot_td}
\title{Estimation of hot exhaust emissions with top-down approach}
\usage{
emis_hot_td(veh, lkm, ef, pro_month, params, verbose = FALSE)
}
\arguments{
\item{veh}{"Vehicles" data-frame or spatial feature, wwhere columns are the
 age distribution of that vehicle. and rows each simple feature or region.
The number of rows is equal to the number of streets link}

\item{lkm}{Numeric; mileage by the age of use of each vehicle.}

\item{ef}{Numeric; emission factor with}

\item{pro_month}{Numeric; montly profile to distribuite annual mileage in each month.}

\item{params}{List of parameters; Add columns with information to returning data.frame}

\item{verbose}{Logical; To show more information}
}
\value{
Emissions data.frame
}
\description{
\code{\link{emis_hot_td}} estimates cld start emissions with
a top-down appraoch. This is, annual or monthly emissions or region.
Especifically, the emissions are esitmated for row of the simple feature (row
of the spatial feature).

In general was designed so that each simple feature is a region with
different average monthly temperature.
This funcion, as other in this package, adapts to the class of the input data.
providing flexibility to the user.
}
\examples{
{
# Do not run
euros <- c("V", "V", "IV", "III", "II", "I", "PRE", "PRE")
efh <- ef_ldv_speed(v = "PC", t = "4S", cc = "<=1400", f = "G",
          eu = euros, p = "CO", speed = Speed(34))
lkm <- units::as_units(18:10, "km")*1000
veh_month <- c(rep(8, 1), rep(10, 5), 9, rep(10, 5))
veh <- age_ldv(1:10, agemax = 8)
a <- emis_hot_td(veh = veh, lkm = lkm, ef = efh, verbose = TRUE)
head(a)
plot(aggregate(a$emissions, by = list(a$age), sum)$x,type ="b")
emis_hot_td(veh = veh, lkm = lkm, ef = efh, verbose = TRUE,
params = list(paste0("data_", 1:10), "moredata"))
aa <- emis_hot_td(veh = veh, lkm = lkm, ef = efh,
pro_month = veh_month, verbose = TRUE)
head(aa)
aa <- emis_hot_td(veh = veh, lkm = lkm, ef = efh,
pro_month = veh_month, verbose = FALSE,
params = list(paste0("data_", 1:10), "moredata"))
}
}
\seealso{
\code{\link{ef_ldv_speed}}
}
