% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boostgeom.R
\docType{methods}
\name{bg_intersects}
\alias{bg_intersects}
\alias{bg_intersects,BoostMultiLines,BoostBoxGrid-method}
\alias{bg_intersects,BoostMultiLines,BoostGeometries-method}
\alias{bg_intersects,BoostMultiPoints,BoostGeometries-method}
\alias{bg_intersects,BoostMultiPolygons,BoostBoxGrid-method}
\alias{bg_intersects,BoostMultiPolygons,BoostGeometries-method}
\alias{bg_intersects,BoostMultiPolygons,BoostPointGrid-method}
\title{Test whether two BoostObjects intersect}
\usage{
bg_intersects(obj1, obj2)

\S4method{bg_intersects}{BoostMultiPolygons,BoostBoxGrid}(obj1, obj2)

\S4method{bg_intersects}{BoostMultiLines,BoostBoxGrid}(obj1, obj2)

\S4method{bg_intersects}{BoostMultiPolygons,BoostPointGrid}(obj1, obj2)

\S4method{bg_intersects}{BoostMultiPolygons,BoostGeometries}(obj1, obj2)

\S4method{bg_intersects}{BoostMultiLines,BoostGeometries}(obj1, obj2)

\S4method{bg_intersects}{BoostMultiPoints,BoostGeometries}(obj1, obj2)
}
\arguments{
\item{obj1}{A BoostObject.}

\item{obj2}{A BoostObject.}
}
\value{
A list, with list element i an integer vector with the indices j for which intersects(x[i],y[j]) is TRUE.
}
\description{
Tests whether two BoostObjects intersect (element-wise).
}
\examples{
pts = boost(sf::st_sfc(sf::st_point(c(.5,.5)),
sf::st_point(c(1.5, 1.5)),
sf::st_point(c(2.5, 2.5))))
pol = boost(sf::st_sfc(sf::st_polygon(
list(rbind(c(0,0), c(2,0), c(2,2), c(0,2), c(0,0))))))
bg_intersects(pol, pts)

}

