% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type.R
\name{type_alike}
\alias{type_alike}
\title{Compare Types of Objects}
\usage{
type_alike(target, current, settings = NULL)
}
\arguments{
\item{target}{the object to test type alikeness against}

\item{current}{the object to test the type alikeness of}

\item{settings}{NULL, or a list as produced by \code{\link[=vetr_settings]{vetr_settings()}}}
}
\description{
By default, checks \code{\link{type_of}} objects and two objects are
considered \code{type_alike} if they have the same type.  There is special
handling for integers, numerics, and functions.
}
\details{
For integers and numerics, if \code{current} is integer or integer-like
(e.g. 1.0) it will match real or integer \code{target} values.  Closures,
built-ins, and specials are all treated as type function.

Specific behavior can be tuned with the \code{type.mode} parameter to the
\code{\link[=vetr_settings]{vetr_settings()}} object passed as the \code{settings} parameter to this function.
}
\seealso{
type_of, alike, \code{\link[=vetr_settings]{vetr_settings()}}, in particular the section about
the \code{type.mode} parameter which affects how this function behaves.
}
