% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viraltab.R
\name{viraltab}
\alias{viraltab}
\title{Competing models table}
\usage{
viraltab(
  traindata,
  semilla,
  target,
  viralvars,
  logbase,
  pliegues,
  repeticiones,
  rejilla
)
}
\arguments{
\item{traindata}{A data frame}

\item{semilla}{A numeric value}

\item{target}{A character value}

\item{viralvars}{Vector of variable names related to viral data.}

\item{logbase}{The base for logarithmic transformations.}

\item{pliegues}{A numeric value}

\item{repeticiones}{A numeric value}

\item{rejilla}{A numeric value}
}
\value{
A table of competing models
}
\description{
Trains and optimizes a series of regression models for viral load or CD4
counts
}
\examples{
\donttest{
library(dplyr)
library(baguette)
library(kernlab)
library(kknn)
library(ranger)
library(rules)
library(glmnet)
# Define the function to impute values in the undetectable range
impute_undetectable <- function(column) {
set.seed(123)
ifelse(column <= 40,
      rexp(sum(column <= 40), rate = 1/13) + 1,
            column)
            }
library(viraldomain)
data("viral", package = "viraldomain")
viral_imputed <- viral |>
mutate(across(starts_with("vl"), ~impute_undetectable(.x)))
traindata <- viral_imputed
semilla <- 1501
target <- "cd_2022"
viralvars <- c("vl_2019", "vl_2021", "vl_2022")
logbase <- 10
pliegues <- 2
repeticiones <- 1
rejilla <- 1
set.seed(123)
viraltab(traindata, semilla, target, viralvars, logbase, pliegues, repeticiones, rejilla)
}
}
