% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales.R
\name{viridis_pal}
\alias{viridis_pal}
\title{Viridis palette (discrete)}
\usage{
viridis_pal(alpha = 1, begin = 0, end = 1, option = "D")
}
\arguments{
\item{alpha}{pass through parameter to \code{viridis}}

\item{begin}{The (corrected) hue in [0,1] at which the viridis colormap begins.}

\item{end}{The (corrected) hue in [0,1] at which the viridis colormap ends.}

\item{option}{A character string indicating the colormap option to use. Four
options are available: "magma" (or "A"), "inferno" (or "B"), "plasma" (or "C"),
and "viridis" (or "D", the default option).}
}
\description{
Viridis palette (discrete)
}
\details{
See \link[viridis]{viridis} for more information on the color scale.
}
\examples{
library(scales)
show_col(viridis_pal()(10))

}
\author{
Bob Rudis \email{bob@rudis.net}
}

