% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sp.env.functions.R
\name{betaFun}
\alias{betaFun}
\title{Beta response function}
\usage{
betaFun(x, p1, p2, alpha, gamma)
}
\arguments{
\item{x}{a numeric value or vector. The input environmental variable.}

\item{p1}{a numeric value or vector. Lower tolerance bound for the species}

\item{p2}{a a numeric value or vector. Upper tolerance bound for the species}

\item{alpha}{a numeric value or vector. Parameter controlling the shape of the curve (see details)}

\item{gamma}{a numeric value or vector. Parameter controlling the shape of the curve (see details)}
}
\value{
a numeric value or vector resulting from the function
}
\description{
Generation of a beta response curve (see references) according to the equation:
\deqn{\frac{1}{{1 + e^{\frac{x - \beta}{\alpha}}}}}{
P = k (x - p1)^\alpha (p2 - x)^\gamma}
k is automatically estimated to have a maximum value of P equal to 1.
}
\details{
p1 and p2 can be seen as the upper and lower critical threshold of the curve.
\code{alpha} and \code{gamma} control the shape of the curve near p1 and p2, respectively.
When \code{alpha} = \code{gamma}, the curve is symetric. Low values of \code{alpha} and \code{gamma}
result in smooth (< 1) to plateau (< 0.01) curves. Higher values result in
peak (> 10) curves.

When \code{alpha} < \code{gamma}, the curve is skewed to the right.
When \code{gamma} < \code{alpha}, the curve is skewed to the left.
}
\examples{
temp <- seq(-10, 40, length = 100)
# A curve similar to a thermal performance curve
P <- betaFun(x = temp, p1 = 0, p2 = 35, alpha = 0.9, gamma = 0.08)
plot(P ~ temp, type = "l")
}
\author{
Boris Leroy \email{leroy.boris@gmail.com}

Maintainer: Boris Leroy \email{leroy.boris@gmail.com}
}
\references{
Oksanen, J. & Minchin, P.R. (2002). Continuum theory revisited: what shape
are species responses along ecological gradients? \emph{Ecological Modelling}
\bold{157}:119-129.
}
\seealso{
\code{\link{linearFun}}, \code{\link{quadraticFun}}, \code{\link{custnorm}}
}

