% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/visGroups.R
\name{visGroups}
\alias{visGroups}
\title{Network visualization groups options}
\usage{
visGroups(graph, useDefaultGroups = NULL, groupname = NULL, ...)
}
\arguments{
\item{graph}{: a visNetwork object}

\item{useDefaultGroups}{: Boolean. Default to true. If your nodes have groups defined that are not in the Groups module, the module loops over the groups it does have, allocating one for each unknown group. When all are used, it goes back to the first group. By setting this to false, the default groups will not be used in this cycle.}

\item{groupname}{: String. Name of target group.}

\item{...}{: \link{visNodes}. You can add multiple groups containing styling information that applies to a certain subset of groups. All options described in the nodes module that make sense can be used here (you're not going to set the same id or x,y position for a group of nodes)}
}
\description{
Network visualization groups options. For full documentation, have a look at \link{visDocumentation}.
}
\examples{
nodes <- data.frame(id = 1:10, label = paste("Label", 1:10),
 group = sample(c("A", "B"), 10, replace = TRUE))
edges <- data.frame(from = c(2,5,10), to = c(1,2,10))

visNetwork(nodes, edges, legend = TRUE) \%>\%
 visGroups(groupname = "A", color = "red", shape = "database") \%>\%
 visGroups(groupname = "B", color = "yellow", shape = "triangle")
}
\seealso{
\link{visNodes} for nodes options, \link{visEdges} for edges options, \link{visGroups} for groups options,
\link{visLegend} for adding legend, \link{visOptions} for custom option, \link{visLayout} & \link{visHierarchicalLayout} for layout,
\link{visPhysics} for control physics, \link{visInteraction} for interaction, \link{visDocumentation}, \link{visEvents}, \link{visConfigure} ...
}

