% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentationHelper.R
\name{plotDoc}
\alias{plotDoc}
\title{Helper for consistent documentation of \code{plots}.}
\arguments{
\item{result}{A \verb{<summarised_result>} object.}

\item{x}{Column or estimate name that is used as x variable.}

\item{y}{Column or estimate name that is used as y variable.}

\item{width}{Bar width, as in \code{geom_col()} of the \code{ggplot2} package.}

\item{just}{Adjustment for column placement, as in \code{geom_col()} of the
\code{ggplot2} package.}

\item{facet}{Variables to facet by, a formula can be provided to specify
which variables should be used as rows and which ones as columns.}

\item{colour}{Columns to use to determine the colours.}

\item{group}{Columns to use to determine the group.}

\item{label}{Character vector with the columns to display interactively in
\code{plotly}.}

\item{style}{Which style to apply to the plot, options are:
"default", "darwin" and NULL (default ggplot style).
Customised styles can be achieved by modifying the returned ggplot object.}

\item{lower}{Estimate name for the lower quantile of the box.}

\item{middle}{Estimate name for the middle line of the box.}

\item{upper}{Estimate name for the upper quantile of the box.}

\item{line}{Whether to plot a line using \code{geom_line}.}

\item{point}{Whether to plot points using \code{geom_point}.}

\item{ribbon}{Whether to plot a ribbon using \code{geom_ribbon}.}

\item{ymin}{Lower limit of error bars, if provided is plot using
\code{geom_errorbar}.}

\item{ymax}{Upper limit of error bars, if provided is plot using
\code{geom_errorbar}.}
}
\description{
Helper for consistent documentation of \code{plots}.
}
\keyword{internal}
