% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helperFunctions.R
\name{setGlobalTableOptions}
\alias{setGlobalTableOptions}
\title{Set format options for all subsequent tables}
\usage{
setGlobalTableOptions(style = NULL, type = NULL)
}
\arguments{
\item{style}{Named list that specifies how to style the different parts of
the gt or flextable table generated. Accepted style entries are: title,
subtitle, header, header_name, header_level, column_name, group_label, and
body.
Alternatively, use "default" to get visOmopResults style, or NULL for
gt/flextable style.
Keep in mind that styling code is different for gt and flextable.
Additionally, "datatable" and "reactable" have their own style functions.
To see style options for each table type use \code{tableStyle()}.}

\item{type}{The desired format of the output table. See \code{tableType()} for
allowed options. If "tibble", no formatting will be applied.}
}
\description{
Set format options for all subsequent tables unless state a different style
in a specific function
}
\examples{
setGlobalTableOptions(style = "darwin", type = "tinytable")
result <- mockSummarisedResult()
result |>
  visOmopTable(
    estimateName = c("N\%" = "<count> (<percentage>)",
                     "N" = "<count>",
                     "Mean (SD)" = "<mean> (<sd>)"),
    header = c("cohort_name"),
    rename = c("Database name" = "cdm_name"),
    groupColumn = strataColumns(result)
  )

}
