% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visit_stan.R
\name{vtPost}
\alias{vtPost}
\title{Postetrior sampling for given observed samples}
\usage{
vtPost(obs.y, prob.mdl = c("NONPARA", "NONPARA+", "PARA", "PARA+"),
  priors = NULL, ..., nsmp = 4000, prior.const = 0.5)
}
\arguments{
\item{obs.y}{Observed data matrix with \eqn{l} rows and 4 columns. Row \eqn{k} in the matrix
    represents the observed data from dose level \eqn{k}. The columns are

\itemize{
    \item{column 1: }{number of patient with no DLT, no immune response}
    \item{column 2: }{number of patient with no DLT, immune response}
    \item{column 3: }{number of patient with DLT, no immune response}
    \item{column 4: }{number of patient with DLT, immune response}
}}

\item{prob.mdl}{Option of the probability models:

\itemize{\item{NONPARA: }{non-parametric+ model}

 \item{NONPARA+: }{non-parametric model}

\item{PARA: }{partially parametric model}

\item{PARA+: }{partially parametric+ model} }

Default value is \code{NONPARA}. See \code{\link{visit}} for details.}

\item{priors}{A class \code{VTPRIOR} object created by
\code{\link{vtPriorPar}} for \code{PARA} and \code{PARA+} model.}

\item{...}{additional parameters for package rstan's sampling method. These
options include \code{warmup}, \code{thin}, \code{algorithm}. See
\code{rstan::sampling} for details.}

\item{nsmp}{number of iterations}

\item{prior.const}{Specify \eqn{\alpha} for a Beta(\eqn{\alpha},
\eqn{\alpha}) prior. The Beta prior is used for \code{NONPARA} and
\code{NONPARA+} models. Default value \eqn{0.5}.}
}
\value{
A class \code{VTPOST} matrix of posterior samples with \code{nsmp}
    rows and 4 columns. Columns 1-4 correspond to\eqn{\theta^{(l)}_{00},
    \theta^{(l)}_{01}, \theta^{(l)}_{10}, \theta^{(l)}_{11}}. See
    \code{\link{visit}} for details about \eqn{\theta}'s.
}
\description{
Call STAN to draw posterior samples of the joint distribution of
immunogenicity rate and toxicity risk
}
\examples{
obs.y    <- rbind(c(5, 2, 0, 0), c(3, 4, 0, 0), c(1, 6, 0, 0))
prior <- vtPriorPar(prior.y = NULL, tau = c(0.1, 0.3, 0.6), sdalpha=10, sdrho=10, vtheta=NULL)
rst.post <- vtPost(obs.y, priors = prior, warmup = 100, prob.mdl = "PARA", nsmp = 200)

}
