% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visit_stan.R
\name{vtStan}
\alias{vtStan}
\title{Call STAN models for MCMC sampling}
\usage{
vtStan(obs.y, priors, model = 0, iter = 4000, chains = 4,
  warmup = 2000, ...)
}
\arguments{
\item{obs.y}{Observed data matrix with \eqn{l} rows and 4 columns. Row \eqn{k} in the matrix
    represents the observed data from dose level \eqn{k}. The columns are

\itemize{
    \item{column 1: }{number of patient with no DLT, no immune response}
    \item{column 2: }{number of patient with no DLT, immune response}
    \item{column 3: }{number of patient with DLT, no immune response}
    \item{column 4: }{number of patient with DLT, immune response}
}}

\item{priors}{A class \code{VTPRIOR} object created by
\code{\link{vtPriorPar}} for \code{PARA} and \code{PARA+} model.}

\item{model}{option of the probability models:
\describe{
  \item{0:}{parametric model}
  \item{1:}{parametric+ model}
}
See \code{\link{visit}} for details.}

\item{iter}{STAN option: number of iterations}

\item{chains}{STAN option: number of chains}

\item{warmup}{STAN option: number of warmup}

\item{...}{additional parameters for package rstan's sampling method. These
options include \code{iter}, \code{warmup}, \code{thin},
\code{algorithm}. See \code{rstan::sampling} for details.}
}
\value{
A \code{rstan} object that contains the posterior sampling results
}
\description{
Call STAN to draw posterior samples of the joint distribution of
immunogenicity rate and toxicity risk for parametric and parametric+ model
}
