// Generated by rstantools.  Do not edit by hand.

/*
    Test is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Test is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Test.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_visit_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_visit");
    reader.add_event(107, 105, "end", "model_visit");
    return reader;
}
template <typename T0__, typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, 1>
ftheta(const T0__& ptox,
           const T1__& pres,
           const T2__& rho, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 3;
        validate_non_negative_index("theta", "4", 4);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> theta(4);
        stan::math::initialize(theta, DUMMY_VAR__);
        stan::math::fill(theta, DUMMY_VAR__);
        current_statement_begin__ = 4;
        if (as_bool(logical_eq(1, rho))) {
            current_statement_begin__ = 5;
            stan::model::assign(theta, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        ((1 - ptox) * (1 - pres)), 
                        "assigning variable theta");
            current_statement_begin__ = 6;
            stan::model::assign(theta, 
                        stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                        ((1 - ptox) * pres), 
                        "assigning variable theta");
            current_statement_begin__ = 7;
            stan::model::assign(theta, 
                        stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list()), 
                        (ptox * (1 - pres)), 
                        "assigning variable theta");
            current_statement_begin__ = 8;
            stan::model::assign(theta, 
                        stan::model::cons_list(stan::model::index_uni(4), stan::model::nil_index_list()), 
                        (ptox * pres), 
                        "assigning variable theta");
        } else {
            current_statement_begin__ = 10;
            stan::model::assign(theta, 
                        stan::model::cons_list(stan::model::index_uni(4), stan::model::nil_index_list()), 
                        ((-((stan::math::sqrt((pow(((((ptox + pres) - (ptox * rho)) - (pres * rho)) - 1), 2) - ((((4 * (rho - 1)) * ptox) * pres) * rho))) + ((((ptox + pres) - (ptox * rho)) - (pres * rho)) - 1))) / 2) / (rho - 1)), 
                        "assigning variable theta");
            current_statement_begin__ = 13;
            if (as_bool(logical_lt(get_base1(theta, 4, "theta", 1), 0))) {
                current_statement_begin__ = 14;
                stan::model::assign(theta, 
                            stan::model::cons_list(stan::model::index_uni(4), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable theta");
            }
            current_statement_begin__ = 16;
            stan::model::assign(theta, 
                        stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list()), 
                        (ptox - get_base1(theta, 4, "theta", 1)), 
                        "assigning variable theta");
            current_statement_begin__ = 17;
            if (as_bool(logical_lt(get_base1(theta, 3, "theta", 1), 0))) {
                current_statement_begin__ = 18;
                stan::model::assign(theta, 
                            stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable theta");
            }
            current_statement_begin__ = 20;
            stan::model::assign(theta, 
                        stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                        (pres - get_base1(theta, 4, "theta", 1)), 
                        "assigning variable theta");
            current_statement_begin__ = 21;
            if (as_bool(logical_lt(get_base1(theta, 2, "theta", 1), 0))) {
                current_statement_begin__ = 22;
                stan::model::assign(theta, 
                            stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable theta");
            }
            current_statement_begin__ = 24;
            stan::model::assign(theta, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        (((rho * get_base1(theta, 2, "theta", 1)) * get_base1(theta, 3, "theta", 1)) / get_base1(theta, 4, "theta", 1)), 
                        "assigning variable theta");
        }
        current_statement_begin__ = 27;
        stan::math::assign(theta, multiply(theta, (1 / sum(theta))));
        current_statement_begin__ = 28;
        return stan::math::promote_scalar<fun_return_scalar_t__>(theta);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct ftheta_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, 1>
    operator()(const T0__& ptox,
           const T1__& pres,
           const T2__& rho, std::ostream* pstream__) const {
        return ftheta(ptox, pres, rho, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_visit
  : public stan::model::model_base_crtp<model_visit> {
private:
        int NDOSE;
        std::vector<double> TAU;
        std::vector<std::vector<double> > PAR;
        double SDALPHA;
        int NOBSLEVEL;
        std::vector<std::vector<int> > OBSY;
        int SINGLEALPHA;
        int SINGLERHO;
        int FIXRHOAT1;
public:
    model_visit(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_visit(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_visit_namespace::model_visit";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 34;
            context__.validate_dims("data initialization", "NDOSE", "int", context__.to_vec());
            NDOSE = int(0);
            vals_i__ = context__.vals_i("NDOSE");
            pos__ = 0;
            NDOSE = vals_i__[pos__++];
            check_greater_or_equal(function__, "NDOSE", NDOSE, 0);
            current_statement_begin__ = 36;
            validate_non_negative_index("TAU", "NDOSE", NDOSE);
            context__.validate_dims("data initialization", "TAU", "double", context__.to_vec(NDOSE));
            TAU = std::vector<double>(NDOSE, double(0));
            vals_r__ = context__.vals_r("TAU");
            pos__ = 0;
            size_t TAU_k_0_max__ = NDOSE;
            for (size_t k_0__ = 0; k_0__ < TAU_k_0_max__; ++k_0__) {
                TAU[k_0__] = vals_r__[pos__++];
            }
            size_t TAU_i_0_max__ = NDOSE;
            for (size_t i_0__ = 0; i_0__ < TAU_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "TAU[i_0__]", TAU[i_0__], 0);
            }
            current_statement_begin__ = 38;
            validate_non_negative_index("PAR", "NDOSE", NDOSE);
            validate_non_negative_index("PAR", "4", 4);
            context__.validate_dims("data initialization", "PAR", "double", context__.to_vec(NDOSE,4));
            PAR = std::vector<std::vector<double> >(NDOSE, std::vector<double>(4, double(0)));
            vals_r__ = context__.vals_r("PAR");
            pos__ = 0;
            size_t PAR_k_0_max__ = NDOSE;
            size_t PAR_k_1_max__ = 4;
            for (size_t k_1__ = 0; k_1__ < PAR_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < PAR_k_0_max__; ++k_0__) {
                    PAR[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 40;
            context__.validate_dims("data initialization", "SDALPHA", "double", context__.to_vec());
            SDALPHA = double(0);
            vals_r__ = context__.vals_r("SDALPHA");
            pos__ = 0;
            SDALPHA = vals_r__[pos__++];
            check_greater_or_equal(function__, "SDALPHA", SDALPHA, 0);
            current_statement_begin__ = 43;
            context__.validate_dims("data initialization", "NOBSLEVEL", "int", context__.to_vec());
            NOBSLEVEL = int(0);
            vals_i__ = context__.vals_i("NOBSLEVEL");
            pos__ = 0;
            NOBSLEVEL = vals_i__[pos__++];
            check_greater_or_equal(function__, "NOBSLEVEL", NOBSLEVEL, 0);
            current_statement_begin__ = 45;
            validate_non_negative_index("OBSY", "(NOBSLEVEL + 1)", (NOBSLEVEL + 1));
            validate_non_negative_index("OBSY", "4", 4);
            context__.validate_dims("data initialization", "OBSY", "int", context__.to_vec((NOBSLEVEL + 1),4));
            OBSY = std::vector<std::vector<int> >((NOBSLEVEL + 1), std::vector<int>(4, int(0)));
            vals_i__ = context__.vals_i("OBSY");
            pos__ = 0;
            size_t OBSY_k_0_max__ = (NOBSLEVEL + 1);
            size_t OBSY_k_1_max__ = 4;
            for (size_t k_1__ = 0; k_1__ < OBSY_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < OBSY_k_0_max__; ++k_0__) {
                    OBSY[k_0__][k_1__] = vals_i__[pos__++];
                }
            }
            size_t OBSY_i_0_max__ = (NOBSLEVEL + 1);
            size_t OBSY_i_1_max__ = 4;
            for (size_t i_0__ = 0; i_0__ < OBSY_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < OBSY_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "OBSY[i_0__][i_1__]", OBSY[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 48;
            context__.validate_dims("data initialization", "SINGLEALPHA", "int", context__.to_vec());
            SINGLEALPHA = int(0);
            vals_i__ = context__.vals_i("SINGLEALPHA");
            pos__ = 0;
            SINGLEALPHA = vals_i__[pos__++];
            check_greater_or_equal(function__, "SINGLEALPHA", SINGLEALPHA, 0);
            current_statement_begin__ = 49;
            context__.validate_dims("data initialization", "SINGLERHO", "int", context__.to_vec());
            SINGLERHO = int(0);
            vals_i__ = context__.vals_i("SINGLERHO");
            pos__ = 0;
            SINGLERHO = vals_i__[pos__++];
            check_greater_or_equal(function__, "SINGLERHO", SINGLERHO, 0);
            current_statement_begin__ = 50;
            context__.validate_dims("data initialization", "FIXRHOAT1", "int", context__.to_vec());
            FIXRHOAT1 = int(0);
            vals_i__ = context__.vals_i("FIXRHOAT1");
            pos__ = 0;
            FIXRHOAT1 = vals_i__[pos__++];
            check_greater_or_equal(function__, "FIXRHOAT1", FIXRHOAT1, 0);
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 54;
            validate_non_negative_index("alpha", "NDOSE", NDOSE);
            num_params_r__ += (1 * NDOSE);
            current_statement_begin__ = 55;
            validate_non_negative_index("rho", "NDOSE", NDOSE);
            num_params_r__ += (1 * NDOSE);
            current_statement_begin__ = 56;
            validate_non_negative_index("pres", "NDOSE", NDOSE);
            num_params_r__ += (1 * NDOSE);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_visit() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 54;
        if (!(context__.contains_r("alpha")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable alpha missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("alpha");
        pos__ = 0U;
        validate_non_negative_index("alpha", "NDOSE", NDOSE);
        context__.validate_dims("parameter initialization", "alpha", "double", context__.to_vec(NDOSE));
        std::vector<double> alpha(NDOSE, double(0));
        size_t alpha_k_0_max__ = NDOSE;
        for (size_t k_0__ = 0; k_0__ < alpha_k_0_max__; ++k_0__) {
            alpha[k_0__] = vals_r__[pos__++];
        }
        size_t alpha_i_0_max__ = NDOSE;
        for (size_t i_0__ = 0; i_0__ < alpha_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_unconstrain(alpha[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable alpha: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 55;
        if (!(context__.contains_r("rho")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rho missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rho");
        pos__ = 0U;
        validate_non_negative_index("rho", "NDOSE", NDOSE);
        context__.validate_dims("parameter initialization", "rho", "double", context__.to_vec(NDOSE));
        std::vector<double> rho(NDOSE, double(0));
        size_t rho_k_0_max__ = NDOSE;
        for (size_t k_0__ = 0; k_0__ < rho_k_0_max__; ++k_0__) {
            rho[k_0__] = vals_r__[pos__++];
        }
        size_t rho_i_0_max__ = NDOSE;
        for (size_t i_0__ = 0; i_0__ < rho_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, rho[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rho: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 56;
        if (!(context__.contains_r("pres")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable pres missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("pres");
        pos__ = 0U;
        validate_non_negative_index("pres", "NDOSE", NDOSE);
        context__.validate_dims("parameter initialization", "pres", "double", context__.to_vec(NDOSE));
        std::vector<double> pres(NDOSE, double(0));
        size_t pres_k_0_max__ = NDOSE;
        for (size_t k_0__ = 0; k_0__ < pres_k_0_max__; ++k_0__) {
            pres[k_0__] = vals_r__[pos__++];
        }
        size_t pres_i_0_max__ = NDOSE;
        for (size_t i_0__ = 0; i_0__ < pres_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lub_unconstrain(0.0000001, 0.99999999, pres[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable pres: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 54;
            std::vector<local_scalar_t__> alpha;
            size_t alpha_d_0_max__ = NDOSE;
            alpha.reserve(alpha_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < alpha_d_0_max__; ++d_0__) {
                if (jacobian__)
                    alpha.push_back(in__.scalar_constrain(lp__));
                else
                    alpha.push_back(in__.scalar_constrain());
            }
            current_statement_begin__ = 55;
            std::vector<local_scalar_t__> rho;
            size_t rho_d_0_max__ = NDOSE;
            rho.reserve(rho_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < rho_d_0_max__; ++d_0__) {
                if (jacobian__)
                    rho.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    rho.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 56;
            std::vector<local_scalar_t__> pres;
            size_t pres_d_0_max__ = NDOSE;
            pres.reserve(pres_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < pres_d_0_max__; ++d_0__) {
                if (jacobian__)
                    pres.push_back(in__.scalar_lub_constrain(0.0000001, 0.99999999, lp__));
                else
                    pres.push_back(in__.scalar_lub_constrain(0.0000001, 0.99999999));
            }
            // transformed parameters
            current_statement_begin__ = 60;
            validate_non_negative_index("ptox", "NDOSE", NDOSE);
            std::vector<local_scalar_t__> ptox(NDOSE, local_scalar_t__(0));
            stan::math::initialize(ptox, DUMMY_VAR__);
            stan::math::fill(ptox, DUMMY_VAR__);
            current_statement_begin__ = 61;
            validate_non_negative_index("theta", "4", 4);
            validate_non_negative_index("theta", "NDOSE", NDOSE);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > theta(NDOSE, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>(4));
            stan::math::initialize(theta, DUMMY_VAR__);
            stan::math::fill(theta, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 63;
            for (int i = 1; i <= NDOSE; ++i) {
                {
                current_statement_begin__ = 64;
                local_scalar_t__ r(DUMMY_VAR__);
                (void) r;  // dummy to suppress unused var warning
                stan::math::initialize(r, DUMMY_VAR__);
                stan::math::fill(r, DUMMY_VAR__);
                current_statement_begin__ = 65;
                local_scalar_t__ a(DUMMY_VAR__);
                (void) a;  // dummy to suppress unused var warning
                stan::math::initialize(a, DUMMY_VAR__);
                stan::math::fill(a, DUMMY_VAR__);
                current_statement_begin__ = 67;
                if (as_bool(logical_eq(1, FIXRHOAT1))) {
                    current_statement_begin__ = 68;
                    stan::math::assign(r, 1);
                } else if (as_bool(logical_eq(1, SINGLERHO))) {
                    current_statement_begin__ = 70;
                    stan::math::assign(r, get_base1(rho, 1, "rho", 1));
                } else {
                    current_statement_begin__ = 72;
                    stan::math::assign(r, get_base1(rho, i, "rho", 1));
                }
                current_statement_begin__ = 75;
                if (as_bool(logical_eq(1, SINGLEALPHA))) {
                    current_statement_begin__ = 76;
                    stan::math::assign(a, get_base1(alpha, 1, "alpha", 1));
                } else {
                    current_statement_begin__ = 78;
                    stan::math::assign(a, get_base1(alpha, i, "alpha", 1));
                }
                current_statement_begin__ = 81;
                stan::model::assign(ptox, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            pow(get_base1(TAU, i, "TAU", 1), stan::math::exp(a)), 
                            "assigning variable ptox");
                current_statement_begin__ = 82;
                stan::model::assign(theta, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ftheta(get_base1(ptox, i, "ptox", 1), get_base1(pres, i, "pres", 1), r, pstream__), 
                            "assigning variable theta");
                }
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 60;
            size_t ptox_k_0_max__ = NDOSE;
            for (size_t k_0__ = 0; k_0__ < ptox_k_0_max__; ++k_0__) {
                if (stan::math::is_uninitialized(ptox[k_0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: ptox" << "[" << k_0__ << "]";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable ptox: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            size_t ptox_i_0_max__ = NDOSE;
            for (size_t i_0__ = 0; i_0__ < ptox_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "ptox[i_0__]", ptox[i_0__], 0.0000001);
                check_less_or_equal(function__, "ptox[i_0__]", ptox[i_0__], 0.99999999);
            }
            current_statement_begin__ = 61;
            size_t theta_k_0_max__ = NDOSE;
            size_t theta_j_1_max__ = 4;
            for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                    if (stan::math::is_uninitialized(theta[k_0__](j_1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: theta" << "[" << k_0__ << "]" << "(" << j_1__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable theta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            size_t theta_i_0_max__ = NDOSE;
            for (size_t i_0__ = 0; i_0__ < theta_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "theta[i_0__]", theta[i_0__], 0);
                check_less_or_equal(function__, "theta[i_0__]", theta[i_0__], 1);
            }
            // model body
            current_statement_begin__ = 89;
            lp_accum__.add(normal_log<propto__>(get_base1(alpha, 1, "alpha", 1), 0, SDALPHA));
            current_statement_begin__ = 90;
            for (int i = 2; i <= NDOSE; ++i) {
                current_statement_begin__ = 91;
                lp_accum__.add(normal_log<propto__>(get_base1(alpha, i, "alpha", 1), get_base1(alpha, (i - 1), "alpha", 1), SDALPHA));
            }
            current_statement_begin__ = 94;
            for (int i = 1; i <= NDOSE; ++i) {
                current_statement_begin__ = 95;
                lp_accum__.add(beta_log<propto__>(get_base1(pres, i, "pres", 1), get_base1(get_base1(PAR, i, "PAR", 1), 1, "PAR", 2), get_base1(get_base1(PAR, i, "PAR", 1), 2, "PAR", 2)));
                current_statement_begin__ = 96;
                lp_accum__.add(lognormal_log<propto__>(get_base1(rho, i, "rho", 1), get_base1(get_base1(PAR, i, "PAR", 1), 3, "PAR", 2), get_base1(get_base1(PAR, i, "PAR", 1), 4, "PAR", 2)));
            }
            current_statement_begin__ = 100;
            if (as_bool(logical_lt(0, NOBSLEVEL))) {
                current_statement_begin__ = 101;
                for (int i = 1; i <= NOBSLEVEL; ++i) {
                    current_statement_begin__ = 102;
                    lp_accum__.add(multinomial_log<propto__>(get_base1(OBSY, i, "OBSY", 1), get_base1(theta, i, "theta", 1)));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("alpha");
        names__.push_back("rho");
        names__.push_back("pres");
        names__.push_back("ptox");
        names__.push_back("theta");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(NDOSE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NDOSE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NDOSE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NDOSE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NDOSE);
        dims__.push_back(4);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_visit_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        std::vector<double> alpha;
        size_t alpha_d_0_max__ = NDOSE;
        alpha.reserve(alpha_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < alpha_d_0_max__; ++d_0__) {
            alpha.push_back(in__.scalar_constrain());
        }
        size_t alpha_k_0_max__ = NDOSE;
        for (size_t k_0__ = 0; k_0__ < alpha_k_0_max__; ++k_0__) {
            vars__.push_back(alpha[k_0__]);
        }
        std::vector<double> rho;
        size_t rho_d_0_max__ = NDOSE;
        rho.reserve(rho_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < rho_d_0_max__; ++d_0__) {
            rho.push_back(in__.scalar_lb_constrain(0));
        }
        size_t rho_k_0_max__ = NDOSE;
        for (size_t k_0__ = 0; k_0__ < rho_k_0_max__; ++k_0__) {
            vars__.push_back(rho[k_0__]);
        }
        std::vector<double> pres;
        size_t pres_d_0_max__ = NDOSE;
        pres.reserve(pres_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < pres_d_0_max__; ++d_0__) {
            pres.push_back(in__.scalar_lub_constrain(0.0000001, 0.99999999));
        }
        size_t pres_k_0_max__ = NDOSE;
        for (size_t k_0__ = 0; k_0__ < pres_k_0_max__; ++k_0__) {
            vars__.push_back(pres[k_0__]);
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 60;
            validate_non_negative_index("ptox", "NDOSE", NDOSE);
            std::vector<double> ptox(NDOSE, double(0));
            stan::math::initialize(ptox, DUMMY_VAR__);
            stan::math::fill(ptox, DUMMY_VAR__);
            current_statement_begin__ = 61;
            validate_non_negative_index("theta", "4", 4);
            validate_non_negative_index("theta", "NDOSE", NDOSE);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > theta(NDOSE, Eigen::Matrix<double, Eigen::Dynamic, 1>(4));
            stan::math::initialize(theta, DUMMY_VAR__);
            stan::math::fill(theta, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 63;
            for (int i = 1; i <= NDOSE; ++i) {
                {
                current_statement_begin__ = 64;
                local_scalar_t__ r(DUMMY_VAR__);
                (void) r;  // dummy to suppress unused var warning
                stan::math::initialize(r, DUMMY_VAR__);
                stan::math::fill(r, DUMMY_VAR__);
                current_statement_begin__ = 65;
                local_scalar_t__ a(DUMMY_VAR__);
                (void) a;  // dummy to suppress unused var warning
                stan::math::initialize(a, DUMMY_VAR__);
                stan::math::fill(a, DUMMY_VAR__);
                current_statement_begin__ = 67;
                if (as_bool(logical_eq(1, FIXRHOAT1))) {
                    current_statement_begin__ = 68;
                    stan::math::assign(r, 1);
                } else if (as_bool(logical_eq(1, SINGLERHO))) {
                    current_statement_begin__ = 70;
                    stan::math::assign(r, get_base1(rho, 1, "rho", 1));
                } else {
                    current_statement_begin__ = 72;
                    stan::math::assign(r, get_base1(rho, i, "rho", 1));
                }
                current_statement_begin__ = 75;
                if (as_bool(logical_eq(1, SINGLEALPHA))) {
                    current_statement_begin__ = 76;
                    stan::math::assign(a, get_base1(alpha, 1, "alpha", 1));
                } else {
                    current_statement_begin__ = 78;
                    stan::math::assign(a, get_base1(alpha, i, "alpha", 1));
                }
                current_statement_begin__ = 81;
                stan::model::assign(ptox, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            pow(get_base1(TAU, i, "TAU", 1), stan::math::exp(a)), 
                            "assigning variable ptox");
                current_statement_begin__ = 82;
                stan::model::assign(theta, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ftheta(get_base1(ptox, i, "ptox", 1), get_base1(pres, i, "pres", 1), r, pstream__), 
                            "assigning variable theta");
                }
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 60;
            size_t ptox_i_0_max__ = NDOSE;
            for (size_t i_0__ = 0; i_0__ < ptox_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "ptox[i_0__]", ptox[i_0__], 0.0000001);
                check_less_or_equal(function__, "ptox[i_0__]", ptox[i_0__], 0.99999999);
            }
            current_statement_begin__ = 61;
            size_t theta_i_0_max__ = NDOSE;
            for (size_t i_0__ = 0; i_0__ < theta_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "theta[i_0__]", theta[i_0__], 0);
                check_less_or_equal(function__, "theta[i_0__]", theta[i_0__], 1);
            }
            // write transformed parameters
            if (include_tparams__) {
                size_t ptox_k_0_max__ = NDOSE;
                for (size_t k_0__ = 0; k_0__ < ptox_k_0_max__; ++k_0__) {
                    vars__.push_back(ptox[k_0__]);
                }
                size_t theta_j_1_max__ = 4;
                size_t theta_k_0_max__ = NDOSE;
                for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
                        vars__.push_back(theta[k_0__](j_1__));
                    }
                }
            }
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_visit";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t alpha_k_0_max__ = NDOSE;
        for (size_t k_0__ = 0; k_0__ < alpha_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rho_k_0_max__ = NDOSE;
        for (size_t k_0__ = 0; k_0__ < rho_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t pres_k_0_max__ = NDOSE;
        for (size_t k_0__ = 0; k_0__ < pres_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pres" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t ptox_k_0_max__ = NDOSE;
            for (size_t k_0__ = 0; k_0__ < ptox_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ptox" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t theta_j_1_max__ = 4;
            size_t theta_k_0_max__ = NDOSE;
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "theta" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t alpha_k_0_max__ = NDOSE;
        for (size_t k_0__ = 0; k_0__ < alpha_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rho_k_0_max__ = NDOSE;
        for (size_t k_0__ = 0; k_0__ < rho_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t pres_k_0_max__ = NDOSE;
        for (size_t k_0__ = 0; k_0__ < pres_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pres" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t ptox_k_0_max__ = NDOSE;
            for (size_t k_0__ = 0; k_0__ < ptox_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ptox" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t theta_j_1_max__ = 4;
            size_t theta_k_0_max__ = NDOSE;
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "theta" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
    }
}; // model
}  // namespace
typedef model_visit_namespace::model_visit stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
