% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_weight.R
\name{calculate_weight}
\alias{calculate_weight}
\title{Calculated empirical density and weight based on variable split.}
\usage{
calculate_weight(profiles, data, variable_split)
}
\arguments{
\item{profiles}{data.frame generated by \code{ingredients::ceteris_paribus()}}

\item{data}{data.frame with raw data to model}

\item{variable_split}{list generated by \code{vivo::calculate_variable_split()}}
}
\value{
Return an weight based on empirical density.
}
\description{
This function calculate an empirical density of raw data based on variable split from Ceteris Paribus profiles. Then calculated weight for values generated by ingredients::ceteris_paribus().
}
\examples{

library("DALEX", warn.conflicts = FALSE, quietly = TRUE)
data(apartments)

library("ingredients", warn.conflicts = FALSE, quietly = TRUE)
split <- vivo::calculate_variable_split(apartments,
                        variables = colnames(apartments))

library("randomForest", warn.conflicts = FALSE, quietly = TRUE)
apartments_rf_model <- randomForest(m2.price ~ construction.year + surface +
                                    floor + no.rooms, data = apartments)

explainer_rf <- explain(apartments_rf_model, data = apartmentsTest[,2:5],
                        y = apartmentsTest$m2.price)

new_apartment <- data.frame(construction.year = 1998, surface = 88, floor = 2L, no.rooms = 3)

profiles <- ceteris_paribus(explainer_rf, new_apartment)

library("vivo")
calculate_weight(profiles, data = apartments[, 2:5], variable_split = split)


}
