% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/racusum_sim.R
\name{cusum_arl_sim}
\alias{cusum_arl_sim}
\title{Compute ARLs of the Bernoulli CUSUM control charts using simulation}
\usage{
cusum_arl_sim(r, h, df, R0 = 1, RA = 2)
}
\arguments{
\item{r}{Integer vector. Number of runs.}

\item{h}{double. Control Chart limit for detecting deterioration/improvement.}

\item{df}{DataFrame. First column are Parsonnet Score values within a range of zero to 100 representing
the preoperative patient risk. The second column are binary (0/1) outcome values of each operation.}

\item{R0}{double. Odds ratio of death under the null hypotheses.}

\item{RA}{double. Odds ratio of death under the alternative hypotheses.}
}
\value{
Returns a single value which is the Run Length.
}
\description{
Compute ARLs of the Bernoulli CUSUM control charts using simulation.
}
\author{
Philipp Wittenberg
}
