% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/racusum_sim.R
\name{bcusum_arl_sim}
\alias{bcusum_arl_sim}
\title{Compute ARLs of the Bernoulli CUSUM control charts using simulation}
\usage{
bcusum_arl_sim(r, h, df, R0 = 1, RA = 2)
}
\arguments{
\item{r}{Integer Vector. Number of runs.}

\item{h}{Double. Control Chart limit for detecting deterioration/improvement.}

\item{df}{Data Frame. First column are Parsonnet Score values within a range of \code{0} to
\code{100} representing the preoperative patient risk. The second column are binary (\code{0/1})
 outcome values of each operation.}

\item{R0}{Double. Odds ratio of death under the null hypotheses.}

\item{RA}{Double. Odds ratio of death under the alternative hypotheses.}
}
\value{
Returns a single value which is the Run Length.
}
\description{
Compute ARLs of the Bernoulli CUSUM control charts using simulation.
}
\author{
Philipp Wittenberg
}
