% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vlda_plot.R
\name{vlda_plot}
\alias{vlda_plot}
\title{VLDA Plot}
\usage{
vlda_plot(fit, rename = NULL, interactive = TRUE,
          title = NULL, title.col = NULL, title.size = 15, title.hjust = 0,
          subtitle = NULL, sub.col = NULL, sub.size = 15, sub.hjust = 0,
          labels = NULL, lab.col = NULL, lab.size = NULL, lab.face = NULL,
          legend.position = "bottom", legend.justification = NULL,
          linetype = 2, line.col = "red", font.size = 1.0, var.size = 2.5,
          obs.col = "darkgray", obs.size = 2.5, add.obs.col = "#666666",
          arrow.col = "orange", arrow.size = 0.5, arrow.type = "closed")
}
\arguments{
\item{fit}{An object returned by \code{vlda()} or \code{supplement()}}

\item{rename}{Rename a variable to another name}

\item{interactive}{Use the interactive graphical elements (default TRUE)}

\item{title}{Plot title. If NULL, the title is not shown (default NULL)}

\item{title.col}{Title color (default color is black)}

\item{title.size}{Title font size (default size = 15)}

\item{title.hjust}{Alignment of title (Number from 0 (left) to 1 (right): \code{left-aligned by default})}

\item{subtitle}{Subtitle for the plot which will be displayed below the title}

\item{sub.col}{Sub-title color (default color is black)}

\item{sub.size}{Sub-title font size (default size = 15)}

\item{sub.hjust}{Alignment of sub-title (Number from 0 (left) to 1 (right): \code{left-aligned by default})}

\item{labels}{Legend labels}

\item{lab.col}{Legend labels color}

\item{lab.size}{Legend labels size}

\item{lab.face}{Legend labels font c(\code{"plain", "bold", "italic", "bold.italic"}) default = "\code{plain}"}

\item{legend.position}{The position of legends (\code{"none", "left", "right", "bottom", "top"}, or two-element numeric vector) default is "\code{bottom}"}

\item{legend.justification}{Anchor point for positioning legend inside plot ("center" or two-element numeric vector) or the justification according to the plot area when positioned outside the plot}

\item{linetype}{Line types can be specified with: An integer or name: 0 = blank, 1 = solid, 2 = dashed, 3 = dotted, 4 = dotdash, 5 = longdash, 6 = twodash, as shown below:}

\item{line.col}{Axis line color}

\item{font.size}{Font size (left-aligned by default size = 1.0)}

\item{var.size}{Variable coordinate point size of plot}

\item{obs.col}{Observation coordinate point color of plot}

\item{obs.size}{Observation coordinate point size on plot}

\item{add.obs.col}{Color of added observation coordinate points}

\item{arrow.col}{Arrow color (default color = "orange")}

\item{arrow.size}{Arrow size (default size = 0.5)}

\item{arrow.type}{One of "\code{open}" or "\code{closed}" indicating whether the arrow head should be a closed triangle}
}
\value{
\item{...}{Same as the result of vlda}
   \item{graphics}{As a result of vlda, it creates a two-dimensional graph. provides interactive graphics, so when the mouse cursor points to the observation coordinates, it provides a tooltip that displays observations of having the same coordinates and displays the row and column coordinate. In the case of long-form, the tooltip displays a time point, besides, coordinate having the same time point are filled with the yellow color on the graph, to make it easier to distinguish the same time points of observations with colors. In the case of a wide form, the combinations that the explanatory variables can have are grouped and the coordinates points of the corresponding observations are shown in yellow on the graph. changes in time points are indicated by orange arrows on the graph.}
}
\description{
Assists in producing a plot that more effectively expresses changes over time for two different types (long format and wide format) using a consistent calling scheme for longitudinal data. It provides the ability to projection supplementary information (supplementary objects and variables) that can often occur in longitudinal data to graphs, as well as provides a new interactive implementation to perform the additional interpretation, so it is also useful for longitudinal data visuals analysis.
}
\details{
Coordinates in opposite directions on each axis can be considered to be different groups. And if the distance between the coordinates is close, it indicates that the group has a similar tendency. Even if the explanatory variable is not significant, a small tendency can confirm because the coordinate is placed in consideration of the relative influence.
}
\examples{
### Long form ###
data(PTSD)
PTSD[,2:4] <- apply(PTSD[,2:4], 2, function(x) ifelse(x >= 3, 1, 0))
PTSD[,5] <-  ifelse(PTSD[,5] >= 6 , 1, 0)
PTSD <- data.frame(lapply(PTSD, function(x) as.factor(x)))
PTSD
str(PTSD)
head(PTSD, 10)
fit <- vlda(x = PTSD, object = "subject", time = "time", type = "long")
vlda_plot(fit)

 ## row and column ##
data(PTSD_row)
data(PTSD_column)
PTSD_row <- as.matrix(PTSD_row)
PTSD_column <- as.matrix(PTSD_column)

fit2 <- vlda_add(fit, add.row = PTSD_row, add.col = PTSD_column)
vlda_plot(fit2)


### Wide form ###
data(Depression)
wide.fit <-
vlda(
  x = Depression,
  object = "Case",
  time = c("1week", "2weeks", "4weeks"),
  type = "wide"
)
vlda_plot(wide.fit)



}
\seealso{
\code{vlda}
}
\keyword{Plot}
\keyword{Visualzation}
