% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/virtualbox.R
\name{virtualboxGitlabRunner}
\alias{virtualboxGitlabRunner}
\title{Configure the guest VM to be use as a Gitlab-Runner}
\usage{
virtualboxGitlabRunner(
  vmr,
  gitlab_url,
  gt_token,
  snapshot_name = "",
  vm_name = ""
)
}
\arguments{
\item{vmr}{a \strong{vmr} object}

\item{gitlab_url}{a GitLab URL}

\item{gt_token}{a GitLab registration token}

\item{snapshot_name}{name of a snapshot to use if any}

\item{vm_name}{the 'VitualBox' VM name if not specified in 'vmr' object provider_options.}
}
\value{
Character command to run in shell to register it
}
\description{
Configure the guest VM to be use as a GitLab Runner
and return the command to run in shell to register it.
}
\examples{
\dontrun{
cmd <- virtualboxGitLabRunner(vmr, "gitlab.com", "mytoken")
system(cmd)
}
}
