% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vocalgraphs.R
\name{getSampledVocalCountMatrix}
\alias{getSampledVocalCountMatrix}
\title{getSampledVocalCountMatrix: generate vocalisation diagrams}
\usage{
getSampledVocalCountMatrix(
  cdf,
  rate = 1,
  individual = FALSE,
  noPauseTypes = FALSE,
  begin = "begin",
  end = "end",
  nodecolumn = "role"
)
}
\arguments{
\item{cdf}{a data frame consisting, minimally, of a column for
vocalisation/pause start times, a column for end times, and a
column identifying the speaker, speaker role or 'Floor' (for
silences).}

\item{rate}{the rate at which to sample the vocalisation events
(in seconds)}

\item{individual}{whether to include individual speakers or group
them into a single Vocalisation node}

\item{noPauseTypes}{if TRUE, ignore distinctions between pauses
(SwitchingPause, GrpSwitchingPause, etc)}

\item{begin}{the name of the column containing the start time of
the vocalisation event in a row.}

\item{end}{the name of the column containing the end time of the
vocalisation event in the same row.}

\item{nodecolumn}{the name of the column containing the node
(speaker) name (e.g. 'speaker', 'role').}
}
\value{
a vocaldia object, consisting of a vocalisation matrix
    (vocmatrix) where cell <m,n> contains the counts of
    transitions from node n to node m, and a table of prior
    probabilities (stationary distribution) per node.
}
\description{
Generate a count vocalisation diagram through 'sampling'.
}
\details{
A vocalisation diagram (vocaldia) is a representation of a
dialogue as a Markov process whose cell <m,n> contains the
transition probability from node n to node m). This function for
'cases' (an identifier for a case or a vector of identifiers
identifying a set of cases) in data frame 'df', obtained by
sampling the timeline every 'rate'-th second (see
getSampledVocalCountMatrix).
}
\examples{
data(vocdia) 
getSampledVocalCountMatrix(subset(atddia,
     id=='Abbott_Maddock_01'), nodecolumn='role')
}
\seealso{
(Luz, 2013)
}
