% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vol2bird.R
\name{vol2bird}
\alias{vol2bird}
\title{Calculate a vertical profile (\code{vp}) from a polar volume (\code{pvol}) file}
\usage{
vol2bird(
  file,
  config,
  vpfile = "",
  pvolfile_out = "",
  verbose = TRUE,
  update_config = FALSE
)
}
\arguments{
\item{file}{Character (vector). Either a path to a single radar polar volume
(\code{pvol}) file containing multiple scans/sweeps, or multiple paths to scan
files containing a single scan/sweep. The file data format should be either 1)
\href{https://github.com/adokter/vol2bird/blob/master/doc/OPERA2014_O4_ODIM_H5-v2.2.pdf}{ODIM}
format, which is the implementation of the OPERA data information model in
the \href{https://support.hdfgroup.org/documentation/}{HDF5} format, 2) NEXRAD format
supported by the \href{https://trmm-fc.gsfc.nasa.gov/trmm_gv/software/rsl/}{'RSL' library} or 3) Vaisala
IRIS (IRIS RAW) format. IRIS format is not available on CRAN, see
vol2birdR development version on Github.}

\item{config}{optional configuration object of class \code{Rcpp_Vol2BirdConfig},
typically output from \link{vol2bird_config}}

\item{vpfile}{Character. File name. When provided with .csv extension, writes a vertical profile
in \href{https://aloftdata.eu/vpts-csv/}{VPTS CSV format}. Provided with another or no extension,
writes a vertical profile in the ODIM HDF5 format to disk.}

\item{pvolfile_out}{Character. File name. When provided, writes a polar
volume (\code{pvol}) file in the ODIM HDF5 format to disk. Useful for converting
'RSL' formats to ODIM, and for adding 'MistNet' segmentation output.}

\item{verbose}{logical. When TRUE print profile output to console.}

\item{update_config}{logical. When TRUE processing options that are determined based on
input file characteristics are returned and updated in the object specified by the \code{config}
argument. Do not set to \code{TRUE} when \code{vol2bird()} is used in loops like \code{lapply()} or in parallel processes.}
}
\value{
No value returned, creates a file specified by \code{file} argument
}
\description{
Calculates a vertical profile of biological scatterers (\code{vp}) from a polar
volume (\code{pvol}) file using the algorithm
\href{https://github.com/adokter/vol2bird/}{vol2bird} (Dokter et al.
2011 \doi{10.1098/rsif.2010.0116}).
}
\examples{
# Locate the polar volume example file
pvolfile <- system.file("extdata", "volume.h5", package = "vol2birdR")

# Create a configuration instance:
conf <- vol2bird_config()

# Define output file
output_file <- paste0(tempdir(), "/vp.h5")

# Calculate the profile:
vol2bird(file = pvolfile, config = conf, vpfile = output_file)

}
\seealso{
\itemize{
\item \code{\link[=vol2bird_config]{vol2bird_config()}}
}
}
