% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_counts_one}
\alias{plot_counts_one}
\title{Plot the frequency of  values in one column.}
\usage{
plot_counts_one(
  data,
  col,
  missings = FALSE,
  numbers = NULL,
  title = TRUE,
  labels = TRUE,
  clean = TRUE,
  ...
)
}
\arguments{
\item{data}{A tibble}

\item{col}{The column holding values to count}

\item{missings}{Include missing values (default FALSE)}

\item{numbers}{The values to print on the bars: "n" (frequency), "p" (percentage) or both.}

\item{title}{If TRUE (default) shows a plot title derived from the column labels.
Disable the title with FALSE or provide a custom title as character value.}

\item{labels}{If TRUE (default) extracts labels from the attributes, see \link{codebook}.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Placeholder to allow calling the method with unused parameters from \link{plot_counts}.}
}
\value{
A ggplot object
}
\description{
Note: only non-missing cases are used to calculate the percentage.
}
\examples{
library(volker)
data <- volker::chatgpt

plot_counts_one(data, sd_gender)

}
\keyword{internal}
