% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualizations.R
\name{pointCompMap}
\alias{pointCompMap}
\title{Comparative point mapping}
\usage{
pointCompMap(
  occs1,
  occs2,
  spName,
  land = NA,
  occs1Col = "#bd0026",
  occs2Col = "#fd8d3c",
  agreeCol = "black",
  occs1Name = "Set 1",
  occs2Name = "Set 2",
  landCol = "gray",
  waterCol = "steelblue",
  ptSize = 1,
  ...
)
}
\arguments{
\item{occs1}{A \code{data.frame} with at least two columns
named "longitude" and "latitude" or that
can be coerced into this format.}

\item{occs2}{A \code{data.frame} with at least two columns
named "longitude" and "latitude" or that
can be coerced into this format.}

\item{spName}{A character string with the species
name to be used in the plot title.}

\item{land}{An optional coastline polygon shapefile
of type \code{sf} to provide geographic context for the
occurrence points.}

\item{occs1Col}{Color for occurrence points on map}

\item{occs2Col}{Color for occurrence points on map}

\item{agreeCol}{Color for occurrence points shared
between \code{occs1} and \code{occs2}.}

\item{occs1Name}{An optional name for the first set
of occurrences, which will be color-coded to
\code{occs1Col} in the resulting plot.}

\item{occs2Name}{An optional name for the first set
of occurrences, which will be color-coded to
\code{occs2Col} in the resulting plot.}

\item{landCol}{Color for land on map}

\item{waterCol}{Color for water on map}

\item{ptSize}{\code{numeric} value for \code{cex};
size of occurrence points on map.}

\item{...}{Additional optional arguments to pass to
\code{ggplot} initial plot object.}
}
\value{
A \code{ggplot} plot object.
}
\description{
A convenient wrapper around \code{ggplot}
to generate formatted plots comparing two sets of
occurrence point plots.
}
\note{
The x and y column names of \code{occs1} and \code{occs2}
must match.
}
\examples{
occs <- read.csv(system.file("extdata/Steindachneria_argentea.csv",
                             package='voluModel'))
set.seed(0)
occs1 <- occs[sample(1:nrow(occs),
                     size = 24, replace = FALSE),]
set.seed(10)
occs2 <- occs[sample(1:nrow(occs),
                     size = 24, replace = FALSE),]

spName <- "Steindachneria argentea"


pointCompMap(occs1 = occs1, occs2 = occs2,
             occs1Col = "red", occs2Col = "orange",
             agreeCol = "purple",
             occs1Name = "2D",
             occs2Name = "3D",
             landCol = "black",
             waterCol = "steelblue",
             spName = spName,
             ptSize = 2)

}
\seealso{
\code{\link[ggplot2:ggplot]{ggplot}}
}
\keyword{plotting}
