% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Collect.search.twitter.R
\name{Collect.search.twitter}
\alias{Collect.search.twitter}
\title{Collect tweet data from twitter search}
\usage{
\method{Collect}{search.twitter}(
  credential,
  endpoint,
  searchTerm = "",
  searchType = "recent",
  numTweets = 100,
  includeRetweets = TRUE,
  retryOnRateLimit = TRUE,
  writeToFile = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{credential}{A \code{credential} object generated from \code{Authenticate} with class name \code{"twitter"}.}

\item{endpoint}{API endpoint.}

\item{searchTerm}{Character string. Specifies a twitter search term. For example, \code{"Australian politics"} or the
hashtag \code{"#auspol"}.}

\item{searchType}{Character string. Returns filtered tweets as per search type \code{recent}, \code{mixed} or
\code{popular}. Default type is \code{recent}.}

\item{numTweets}{Numeric. Specifies how many tweets to be collected. Defaults is \code{100}.}

\item{includeRetweets}{Logical. Specifies if the search should filter out retweets. Defaults is \code{TRUE}.}

\item{retryOnRateLimit}{Logical. When the API rate-limit is reached should the collection wait and resume when it resets. Default is \code{TRUE}.}

\item{writeToFile}{Logical. Write collected data to file. Default is \code{FALSE}.}

\item{verbose}{Logical. Output additional information. Default is \code{FALSE}.}

\item{...}{
  Arguments passed on to \code{\link[rtweet:search_tweets]{rtweet::search_tweets}}
  \describe{
    \item{\code{geocode}}{Geographical limiter of the template
"latitude,longitude,radius" e.g., \code{geocode = "37.78,-122.40,1mi"}.}
    \item{\code{since_id}}{Supply a vector of ids or a data frame of previous results to
find tweets \strong{newer} than \code{since_id}.}
    \item{\code{max_id}}{Supply a vector of ids or a data frame of previous results to
find tweets \strong{older} than \code{max_id}.}
    \item{\code{parse}}{If \code{TRUE}, the default, returns a tidy data frame. Use \code{FALSE}
to return the "raw" list corresponding to the JSON returned from the
Twitter API.}
  }}
}
\value{
A tibble object with class names \code{"datasource"} and \code{"twitter"}.
}
\description{
This function collects tweet data based on search terms and structures the data into a dataframe with
the class names \code{"datasource"} and \code{"twitter"}.

The twitter Standard search API sets a rate limit of 180 requests every 15 minutes. A maximum of 100 tweets can be
collected per search request meaning the maximum number of tweets per operation is 18000 / 15 minutes. More tweets
can be collected by using \code{retryOnRateLimit = TRUE} parameter which will cause the collection to pause if the
rate limit is reached and resume when the rate limit resets (in approximately 15 minutes). Alternatively the
twitter API parameter \code{since_id} can be used in a later session to resume a twitter search collection from the
last tweet previously collected as tweet status id's are sequential. The Standard API only returns tweets for the
last 7 days.

All of the search query operators available through the twitter API can be used in the \code{searchTerm} field. For
example, to search for tweets containing the term \code{"love"} or \code{"hate"} the \code{"OR"} operator can be
used in the term field: \code{searchTerm = "love OR hate"}. For more information refer to the twitter API
documentation for query operators:
\url{https://developer.twitter.com/en/docs/twitter-api/v1/tweets/search/guides/standard-operators}.
}
\note{
Additional parameters passed to this function in the ellipsis \code{...} will also be passed to the Twitter
search API request. Most parameters have been covered but a complete list can be found here:
\url{https://developer.twitter.com/en/docs/twitter-api/v1/tweets/search/api-reference/get-search-tweets} A useful
additional parameter is \code{language} allowing the user can restrict tweets returned to a particular language
using an ISO 639-1 code. For example, to restrict a search to tweets in English the value \code{language = "en"}
can be passed to this function.
}
\examples{
\dontrun{
# search and collect 100 recent tweets for the hashtag #auspol
myTwitterData <- twitterAuth |>
  Collect(searchTerm = "#auspol", searchType = "recent", numTweets = 100, verbose = TRUE,
          includeRetweets = FALSE, retryOnRateLimit = TRUE, writeToFile = TRUE)
}

}
