% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vtree.R
\name{vtree}
\alias{vtree}
\title{vtree: Draw a variable tree}
\usage{
vtree(z, vars, prune = list(), prunebelow = list(), keep = list(),
  follow = list(), prunelone = NULL, pruneNA = FALSE,
  labelnode = list(), labelvar = NULL, fillcolor = NULL,
  fillnodes = TRUE, NAfillcolor = "white", rootfillcolor = "#EFF3FF",
  palette = NULL, gradient = TRUE, revgradient = FALSE,
  singlecolor = 2, colorvarlabels = TRUE, title = "",
  sameline = FALSE, Venn = FALSE, check.is.na = FALSE, seq = FALSE,
  text = list(), plain = FALSE, squeeze = 1, shownodelabels = TRUE,
  showvarnames = TRUE, showlevels = TRUE, showpct = TRUE,
  showlpct = TRUE, showcount = TRUE, showlegend = FALSE,
  varnamepointsize = 20, HTMLtext = FALSE, digits = 0,
  splitwidth = 20, lsplitwidth = 15, getscript = FALSE,
  nodesep = 0.5, ranksep = 0.5, margin = 0.2, vp = TRUE,
  horiz = TRUE, summary = "", width = NULL, height = NULL,
  graphattr = "", nodeattr = "", edgeattr = "", color = c("blue",
  "forestgreen", "red", "orange", "pink"), colornodes = FALSE,
  showempty = FALSE, rounded = TRUE, nodefunc = NULL,
  nodeargs = NULL, parent = 1, last = 1, root = TRUE)
}
\arguments{
\item{z}{Required: Data frame, or a single vector.}

\item{vars}{Required (unless \code{z} is a vector):
Either a character string of whitespace-separated variable names
or a vector of variable names.}

\item{prune}{List of vectors that identifies nodes to prune.
The name of each element of the
list must be one of the variable names in \code{vars}.
Each element is a vector of character strings that
identifies the values of the variable (i.e. the nodes) to prune.}

\item{prunebelow}{Like \code{prune} but the nodes themselves are not pruned,
just their descendants.}

\item{keep}{Like \code{prune} but specifies which nodes should be kept (i.e. not pruned).}

\item{follow}{Like \code{prune} but specifies which nodes should be "followed".
For the variables named,
only the descendants of nodes that are followed will be shown.}

\item{prunelone}{A vector of values specifying \emph{lone nodes} (of any variable) to prune.
A lone node is a node that has no siblings.}

\item{pruneNA}{Prune all missing values?
This should be used carefully because "valid" percentages
are hard to interpret when NAs are pruned.}

\item{labelnode}{List of vectors used to change how values of variables are displayed.
The name of each element of the
list is one of the variable names in \code{vars}.
Each element of the list is a vector of character strings,
representing the values of the variable.
The names of the vector represent the labels to be used in place of the values.}

\item{labelvar}{A named vector of labels for variables.}

\item{fillcolor}{A named vector of colors for filling the nodes of each variable.
If an unnamed, scalar color is specified,
all nodes will have this color.}

\item{fillnodes}{Should the nodes be filled with color?}

\item{NAfillcolor}{Fill color for missing value nodes.
If NULL, fill colors of missing value nodes will be consistent
with the fill colors in the rest of the tree.}

\item{rootfillcolor}{Fill color for the root node.}

\item{palette}{A vector of palette numbers (which can range between 1 and 9).
The names of the vector indicate the corresponding variable.
See \strong{Palettes} below for more information.}

\item{gradient}{Should gradients of fill color be used across the values of each variable?
A single value (with no names) specifies the setting for all variables.
A logical vector of TRUE values for named variables is interpreted as
TRUE for those variables and FALSE for all others.
A logical vector of FALSE values for named variables is interpreted as
FALSE for those variables and TRUE for all others.}

\item{revgradient}{Should the gradient be reversed (i.e. dark to light instead of light to dark)?
A single value (with no names) specifies the setting for all variables.
A logical vector of TRUE values for named variables is interpreted as
A logical vector of FALSE values for named variables is interpreted as
FALSE for those variables and TRUE for all others.}

\item{singlecolor}{When a variable has a single value,
should its nodes can be colored light (1) medium (2) or dark (3)?}

\item{colorvarlabels}{Should the variable labels be colored?}

\item{title}{Optional title for the root node of the tree.}

\item{sameline}{Should node labels be on the same line as node percentages?}

\item{Venn}{Display multi-way set membership information?
This provides an alternative to a Venn diagram.
This sets \code{showpct=FALSE}, \code{shownodelabels=FALSE}.
Assumption: all of the specified variables are logicals or 0/1 numeric variables.}

\item{check.is.na}{Replace each variable named in \code{vars} with a logical vector indicating
whether or not each of its values is missing?}

\item{seq}{Display the variable tree using "sequences"?
Each unique sequence (i.e. pattern) of values will be shown separately.}

\item{text}{A list of vectors containing extra text to add to specified nodes.
The name of each element of the list
must be one of the variable names in \code{vars}.
Each element is a vector of character strings.
The names of the vector identify the nodes to which the text should be added.
(See \strong{Formatting codes} below for information
on how to format text.)}

\item{plain}{Use "plain" color settings?}

\item{squeeze}{How much should the tree be "squeezed"?
A value between 0 and 1.
This controls two Graphviz parameters: \code{margin} and \code{nodesep}.}

\item{shownodelabels}{Should node labels be shown?
A single value (with no names) specifies the setting for all variables.
A logical vector of TRUE values for named variables is interpreted as
TRUE for those variables and FALSE for all others.
A logical vector of FALSE values for named variables is interpreted as
FALSE for those variables and TRUE for all others.}

\item{showvarnames}{Show the name of the variable next to each level of the tree?}

\item{showlevels}{(Deprecated) Same as showvarnames.}

\item{showpct}{Show percentage in each node?
A single value (with no names) specifies the setting for all variables.
A logical vector of TRUE for named variables is interpreted as
A logical vector of FALSE for named variables is interpreted as
FALSE for those variables and TRUE for all others.}

\item{showlpct}{Show the (marginal) percentages for values of
each variable in the legend?}

\item{showcount}{Show count in each node?
A single value (with no names) specifies the setting for all variables.
A logical vector of TRUE for named variables is interpreted as
A logical vector of FALSE for named variables is interpreted as
FALSE for those variables and TRUE for all others.}

\item{showlegend}{Show legend (including marginal frequencies) for each variable?}

\item{varnamepointsize}{Font size (in points) to use when displaying variable names.}

\item{HTMLtext}{Is the text formatted in HTML?}

\item{digits}{Number of decimal digits to show in percentages.}

\item{splitwidth}{The minimum number of characters before an automatic
linebreak is inserted.}

\item{lsplitwidth}{The minimum number of characters before an automatic
linebreak is inserted for legends.}

\item{getscript}{Instead of displaying the variable tree,
return the DOT script as a character string?}

\item{nodesep}{Graphviz attribute: Node separation amount.}

\item{ranksep}{Graphviz attribute: Rank separation amount.}

\item{margin}{Graphviz attribute: node margin.}

\item{vp}{Use "valid percentages"?
Valid percentages are computed by first excluding any missing values,
i.e. restricting attention to the set of "valid" observations.
The denominator is thus the number of non-missing observations.
When \code{vp=TRUE}, nodes for missing values show the number of missing values
but do not show a percentage;
all the other nodes how valid percentages.
When \code{vp=FALSE}, all nodes (including nodes for missing values)
show percentages of the total number of observations.}

\item{horiz}{Should the tree be drawn horizontally?
(i.e. parent node on the left, with the tree growing to the right)}

\item{summary}{A character string used to specify summary statistics to display in the nodes.
The first word in the character string is the name of the variable to be summarized.
The rest of the character string is the text that will be displayed,
along with special codes specifying the information to display
(see \strong{Summary codes} below).
A vector of character strings can also be specified,
so that more than one variable may be summarized.}

\item{width}{width (in pixels) to be passed to \code{grViz}.}

\item{height}{height (in pixels) to be passed to \code{grViz}.}

\item{graphattr}{Character string: Additional attributes for the Graphviz graph.}

\item{nodeattr}{Character string: Additional attributes for Graphviz nodes.}

\item{edgeattr}{Character string: Additional attributes for Graphviz edges.}

\item{color}{A vector of color names for the \emph{outline} of the nodes at each level.}

\item{colornodes}{Should the node outlines be colored?}

\item{showempty}{Show nodes that do not contain any observations?}

\item{rounded}{Should the nodes have rounded boxes?}

\item{nodefunc}{A node function (see \strong{Node functions} below).}

\item{nodeargs}{A list containing named arguments for the node function
specified by \code{nodefunc}.}

\item{parent}{Parent node number (Internal use only.)}

\item{last}{Last node number (Internal use only.)}

\item{root}{Is this the root node of the tree? (Internal use only.)}
}
\value{
If \code{getscript=TRUE}, returns a character string of DOT script that describes the variable tree.
If \code{getscript=FALSE}, returns an object of class \code{htmlwidget}
that will intelligently print itself into HTML in a variety of contexts
including the R console, within R Markdown documents, and within Shiny output bindings.
}
\description{
vtree is a tool for drawing variable trees.
Variable trees display information about nested subsets of a data frame,
in which the subsetting is defined by the values of categorical variables.
}
\section{Summary codes}{

\itemize{
 \item{\code{\%mean\%} }{mean}
 \item{\code{\%SD\%} }{standard deviation}
 \item{\code{\%min\%} }{minimum}
 \item{\code{\%max\%} }{maximum}
 \item{\code{\%pX\%} }{Xth percentile, e.g. p50 means the 50th percentile}
 \item{\code{\%median\%} }{median, i.e. p50}
 \item{\code{\%IQR\%} }{interquartile range, i.e. p25, p75}
 \item{\code{\%list\%} }{list of the individual values}
 \item{\code{\%mv\%} }{the number of missing values}
 \item{\code{\%v\%} }{the name of the variable}
 \item{\code{\%noroot\%} }{flag: Do not show summary in the root node.}
 \item{\code{\%leafonly\%} }{flag: Only show summary in leaf nodes.}
 \item{\code{\%var=}n\code{\%} }{flag: Only show summary in nodes of the specified variable.}
 \item{\code{\%trunc=}n\code{\%} }{flag: Truncate the summary to the first n characters.}
}
}

\section{Node functions}{

Node functions provide a mechanism for running a function within each subset
representing a node of the tree. The \code{summary} parameter uses node functions.
A node functions is a function takes as arguments a data frame subset,
 the name of the subsetting variable, the value of the subsetting variable, and
 a list of named arguments.
}

\section{Formatting codes}{

Formatting codes for the \code{text} argument.
Also used by \code{labelnode} and \code{labelvar}.
\itemize{
 \item{\code{\\n} }{line break}
 \item{\code{*...*} }{italics}
 \item{\code{**...**} }{bold}
 \item{\code{^...^} }{superscript (using 10 point font)}
 \item{\code{~...~} }{subscript (using 10 point font)}
 \item{\code{\%\%red ...\%\%} }{display text in red (or whichever color is specified)}
}
}

\section{Palettes}{

Sequential palettes from Color Brewer:
\enumerate{
 \item{Reds}
 \item{Blues}
 \item{Greens}
 \item{Oranges}
 \item{Purples}
 \item{YlGn}
 \item{PuBu}
 \item{PuRd}
 \item{YlOrBr}
}
}

\examples{
# A single-level hierarchy
vtree(FakeData,"Severity")

# A two-level hierarchy
vtree(FakeData,"Severity Sex")

# A two-level hierarchy with pruning of some values of Severity
vtree(FakeData,"Severity Sex",prune=list("Severity"=c("Moderate","NA")))

# Rename some nodes
vtree(FakeData,"Severity Sex",labelnode=list(Sex=(c("Male"="M","Female"="F"))))

# Rename a variable
vtree(FakeData,"Severity Sex",labelvar=c(Severity="How bad?"))

# Show legend. Put labels on the same line as counts and percentages
vtree(FakeData,"Severity Sex Viral",sameline=TRUE,showlegend=TRUE)

# Using the summary parameter to list ID numbers (truncated to 40 characters) in specified nodes
vtree(FakeData,"Severity Sex",summary="id \\nid = \%list\% \%var=Severity\% \%trunc=40\%")

}
\author{
Nick Barrowman <nbarrowman@cheo.on.ca>
}
