% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_fit.R
\name{as.data.frame.walker_fit}
\alias{as.data.frame.walker_fit}
\title{Coerce Posterior Samples of walker Fit to a Data Frame}
\usage{
\method{as.data.frame}{walker_fit}(x, row.names = NULL, optional = FALSE, type, ...)
}
\arguments{
\item{x}{An output from \code{\link{walker}} or \code{\link{walker_glm}}.}

\item{row.names}{\code{NULL} (default) or a character vector giving the row names 
for the data frame.}

\item{optional}{Ignored (part of generic \code{as.data.frame} signature).}

\item{type}{Either \code{tiv} (time-invariant parameters) or \code{tv} (time-varying coefficients).}

\item{...}{Ignored.}
}
\description{
Creates a data.frame object from the output of walker fit.
}
\examples{
\dontrun{
 as.data.frame(fit, "tiv") \%>\% 
 group_by(variable) \%>\%
 summarise(mean = mean(value),
           lwr = quantile(value, 0.05),
           upr = quantile(value, 0.95))
}

}
