% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lfo.R
\name{lfo}
\alias{lfo}
\title{Leave-Future-Out Cross-Validation}
\usage{
lfo(object, L, exact = FALSE, verbose = TRUE, k_thres = 0.7)
}
\arguments{
\item{object}{Output of \code{walker} or \code{walker_glm}.}

\item{L}{Positive integer defining how many observations should be used for the initial fit.}

\item{exact}{If \code{TRUE}, computes exact 1-step predictions by re-estimating the model repeatedly. 
If \code{FALSE} (default), uses approximate method based on Bürkner, Gabry and Vehtari (2020).}

\item{verbose}{If \code{TRUE} (default), print the progress of the LFO computations to the console.}

\item{k_thres}{Threshold for the pareto k estimate triggering refit. Default is 0.7.}
}
\value{
List with components \code{ELPD} (Expected log predictive density), \code{ELPDs} (observation-specific ELPDs),
\code{ks} (Pareto k values in case of approximation was used), and \code{refits} (time points where model was re-estimated)
}
\description{
Estimates the leave-future-out (LFO) information criterion for \code{walker} and \code{walker_glm} models.
}
\details{
The LFO for non-Gaussian models is (currently) based on the corresponding Gaussian approximation and 
not the importance sampling corrected true posterior.
}
\examples{
\dontrun{
fit <- walker(Nile ~ -1 + 
  rw1(~ 1, 
    beta = c(1000, 100), 
    sigma = c(2, 0.001)), 
  sigma_y_prior = c(2, 0.005), 
  iter = 2000, chains = 1)
 
fit_lfo <- lfo(fit, L = 20, exact = FALSE)
fit_lfo$ELPD
}
}
\references{
Paul-Christian Bürkner, Jonah Gabry & Aki Vehtari (2020). 
Approximate leave-future-out cross-validation for Bayesian time series models, 
Journal of Statistical Computation and Simulation, 90:14, 2499-2523, DOI: 10.1080/00949655.2020.1783262.
}
