% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hit_and_run.R
\name{hit_and_run}
\alias{hit_and_run}
\title{Hit and Run}
\usage{
hit_and_run(A, b, x0, points, thin = 1, burn = 0, chains = 1)
}
\arguments{
\item{A}{is the lhs of Ax <= b}

\item{b}{is the rhs of Ax <= b}

\item{x0}{is the starting point (a list of points)}

\item{points}{is the number of points we want to sample}

\item{thin}{every thin-th point is stored}

\item{burn}{the first burn points are deleted}

\item{chains}{is the number of chains we run}
}
\value{
a list of chains of the sampled points, each chain
        being a matrix object with each column as a point
}
\description{
This function provides a wrapper 
for the har function of the 
hit-and-run package
}
\examples{
\dontrun{
## note that this Ax <= b is different from Ax=b that the 
## user specifies for walkr (see transformation section in vignette) 
hit_and_run(A = A, b = b, x0, points = 100, thin = 1, burn = 0, chains = 1) 
} 
}
