% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xcorr.R
\name{xcorr}
\alias{xcorr}
\title{Spectrogram cross-correlation}
\usage{
xcorr(X, wl =512, bp = "pairwise.freq.range", ovlp = 90, dens = NULL, wn='hanning', 
cor.method = "pearson", parallel = 1, path = NULL, pb = TRUE, na.rm = FALSE,
 cor.mat = TRUE, compare.matrix = NULL)
}
\arguments{
\item{X}{'selection_table', 'extended_selection_table' or data frame containing columns for sound files (sound.files), 
selection number (selec), and start and end time of signal (start and end).}

\item{wl}{A numeric vector of length 1 specifying the window length of the spectrogram, default 
is 512.}

\item{bp}{A numeric vector of length 2 for the lower and upper limits of a 
frequency bandpass filter (in kHz) or "pairwise.freq.range" (default) to indicate that values in lowest bottom.freq
and highest top.freq columns for the signals involved in a pairwise comparison will be used as bandpass limits.}

\item{ovlp}{Numeric vector of length 1 specifying \% of overlap between two 
consecutive windows, as in \code{\link[seewave]{spectro}}. Default is 90. High values of ovlp 
slow down the function but produce more accurate results.}

\item{dens}{DEPRECATED.}

\item{wn}{A character vector of length 1 specifying the window name as in \code{\link[seewave]{ftwindow}}.}

\item{cor.method}{A character vector of length 1 specifying the correlation method as in \code{\link[stats]{cor}}.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{path}{Character string containing the directory path where the sound files are located. 
If \code{NULL} (default) then the current working directory is used.}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}.}

\item{na.rm}{Logical. If \code{TRUE} all NAs produced when pairwise cross-correlations failed are removed from the 
results. This means that all selections with at least 1 cross-correlation that failed are excluded.}

\item{cor.mat}{Logical. If \code{TRUE} only the correlation matrix is returned. Default is \code{TRUE}.}

\item{compare.matrix}{A character matrix with 2 columns indicating the selections to be compared (column 1 vs column 2). The columns must contained the ID of the selection, which is given by combining the 'sound.files' and 'selec' columns of 'X',  separated by '-' (i.e. \code{paste(X$sound.files, X$selec, sep = "-")}). Default is \code{NULL}. If supplied only those comparisons will be calculated (as opposed to all pairwise comparisons as the default behavior) and the output will be a data frame composed of the supplied matrix and the correspondent cross-correlation values.}
}
\value{
If corr.mat is \code{TRUE} the function returns a matrix with 
the maximum (peak) correlation for each pairwise comparison. Otherwise it will return a list that includes 1) a data frame with the correlation statistic for each "sliding" step, 2) a matrix with 
the maximum correlation for each pairwise comparison, and 3) the frequency range.
}
\description{
\code{xcorr} estimates the similarity of two spectrograms by means of spectrographic cross-correlation
}
\details{
This function calculates the pairwise similarity of multiple signals by means of spectrogram cross-correlation.
This method "slides" one spectrogram over the other calculating a correlation of the amplitude values at each step.
The function runs pairwise cross-correlations on several signals and returns a list including the correlation statistic
for each "sliding" step as well as the maximum (peak) correlation for each pairwise comparison. To accomplish this the margins
of the signals are expanded by half the duration of the signal both before and after the provided time coordinates. 
The correlation matrix could have NA's if some of the pairwise correlation did not work (common when sound files have been modified by band-pass filters).
}
\examples{
{
#load data
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4","lbh_selec_table"))

#save sound files
writeWave(Phae.long1, file.path(tempdir(), "Phae.long1.wav")) 
writeWave(Phae.long2, file.path(tempdir(), "Phae.long2.wav"))
writeWave(Phae.long3, file.path(tempdir(), "Phae.long3.wav"))
writeWave(Phae.long4, file.path(tempdir(), "Phae.long4.wav"))
# run cross correlation
xcor <- xcorr(X = lbh_selec_table, wl = 300, ovlp = 90, path = tempdir())

# using the 'compare.matrix' argument to specify pairwise comparisons
# create matrix with ID of signals to compare
cmp.mt <- cbind(
paste(lbh_selec_table$sound.files[1:10], lbh_selec_table$selec[1:10], sep = "-"), 
paste(lbh_selec_table$sound.files[2:11], lbh_selec_table$selec[2:11], sep = "-"))

# run cross-correlation on the selected pairwise comparisongs
xcor <- xcorr(X = lbh_selec_table, compare.matrix = cmp.mt, 
wl = 300, ovlp = 90, path = tempdir())
}
}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.

H. Khanna, S.L.L. Gaunt & D.A. McCallum (1997). Digital spectrographic cross-correlation: tests of sensitivity. Bioacoustics 7(3): 209-234
}
}
\seealso{
\code{\link{mfcc_stats}}, \code{\link{specan}}, \code{\link{df_DTW}}
}
\author{
Marcelo Araya-Salas \email{marceloa27@gmail.com})
}
