% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales.R
\name{washi_scale}
\alias{washi_scale}
\title{Scales for plotting with WaSHI palettes}
\usage{
washi_scale(
  palette = "color_blind",
  aesthetics = c("color", "fill"),
  alpha = 1,
  reverse = FALSE,
  discrete = TRUE,
  ...
)
}
\arguments{
\item{palette}{Character name of palette in washi_pal. See
\code{names(washi_pal)} for a list of available palettes.}

\item{aesthetics}{Character string or vector of character strings
listing the name(s) of the aesthetic(s) that this scale works
with. Defaults to c("color", "fill"), which applies the palette
to both the color and fill aesthetics at the same time.}

\item{alpha}{Numeric transparency level of the color from 0 to 1.
Default is 1 (not transparent).}

\item{reverse}{Boolean indicating whether the palette should be
reversed. Default is FALSE.}

\item{discrete}{Boolean indicating whether color aesthetic is
discrete or not. Default is TRUE.}

\item{...}{Additional arguments passed to discrete_scale() or
scale_color_gradientn(), used respectively when discrete is TRUE
or FALSE}
}
\value{
A \code{ScaleContinuous} or \code{ScaleDiscrete} object that can be
added to a \code{ggplot} object.
}
\description{
Provides compatibility with \code{ggplot2}.
}
\examples{
library(ggplot2)

# Discrete scale
example_data_wide |>
  subset(crop \%in\% c("Apple", "Cherry", "Potato")) |>
  ggplot(aes(x = pH, y = Mn_mg.kg, color = crop)) +
  geom_point(size = 2.5) +
  theme_minimal() +
  washi_scale()

# Continuous scale
example_data_wide |>
  ggplot(aes(x = `totalC_\%`, y = poxC_mg.kg, color = poxC_mg.kg)) +
  geom_point(size = 2.5) +
  theme_minimal() +
  washi_scale("green_gradient", reverse = TRUE, discrete = FALSE)
}
\seealso{
Other ggplot2 functions: 
\code{\link{washi_theme}()}
}
\concept{ggplot2 functions}
