% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Signif_param.R
\name{signifparam}
\alias{signifparam}
\title{Computes the parameters significance}
\usage{
signifparam(
  ar = NULL,
  ma = NULL,
  p = NULL,
  q = NULL,
  y,
  sd.strong = NULL,
  sd.weak = NULL,
  meanparam = TRUE,
  mu = NULL
)
}
\arguments{
\item{ar}{Vector of AR coefficients, if \code{NULL}, MA process.}

\item{ma}{Vector of MA coefficients, if \code{NULL}, AR process.}

\item{p}{Order of AR, if \code{NULL} MA process.}

\item{q}{Order of MA, if \code{NULL} AR process.}

\item{y}{Univariate time series.}

\item{sd.strong}{Standard error of time series in the strong case computed in \code{\link[weakARMA]{omega}}, if not provided the function will compute it.}

\item{sd.weak}{Standard error of time series in the weak case computed in \code{\link[weakARMA]{omega}}, if not provided the function will compute it.}

\item{meanparam}{If \eqn{\mu} of the time series needs to be computed.}

\item{mu}{Value of \eqn{\mu}, if it is known and if the \code{meanparam} is \code{TRUE}. If not known the function will compute it.}
}
\value{
Matrix of the estimate coefficient with their significance.
\describe{
    \item{\code{coef}}{Estimation of each coefficient.}
    \item{\code{sd}}{Standard deviation in each case.}
    \item{\code{t-ratio}}{T-ratio corresponding to each coefficient.}
    \item{\code{signif}}{Significance of each parameter. 
    Must be small, if not the parameter is not significant.}
}
}
\description{
Computes a matrix with estimated coefficient and their significance.
}
\details{
The function needs at least one pair between: ar and/or ma, or p and/or q to be executed. It will be faster with all the parameters provided.
}
\examples{
\donttest{signifparam(p = 1, q = 2, y = CAC40return.sq)} #The last parameter is not significant.
\donttest{signifparam(p = 1, q = 1, y = CAC40return.sq)} #All the parameters are significant.

}
