% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stations.R
\name{stations_dl}
\alias{stations_dl}
\alias{stations_all}
\title{Get available stations}
\usage{
stations_dl(
  url = NULL,
  normals_years = "1981-2010",
  skip = NULL,
  verbose = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{url}{DEPRECATED. To set a different url use \code{options()} (see details).}

\item{normals_years}{Character. The year range for which you want climate
normals. Default "1981-2010".}

\item{skip}{Numeric. Number of lines to skip at the beginning of the csv. If
NULL, automatically derived.}

\item{verbose}{Logical. Include progress messages}

\item{quiet}{Logical. Suppress all messages (including messages regarding
missing data, etc.)}
}
\value{
A tibble containing station names, station ID codes, dates of
operation, as well as whether or not there are data on climate normals.
}
\description{
This function can be used to download a Station Inventory CSV file from
Environment and Climate Change Canada. This is only necessary if the station
you're interested was only recently added. The 'stations' data set included
in this package contains station data downloaded when the package was last
compiled. This function may take a few minutes to run.
}
\details{
The stations list is downloaded from the url stored in the option
\code{weathercan.urls.stations}. To change this location use
\code{options(weathercan.urls.stations = "your_new_url")}.

The list of which stations have climate normals is downloaded from the url
stored in the option \code{weathercan.urls.normals}. To change this location use
\code{options(weathercan.urls.normals = "your_new_url")}.
}
\examples{

\donttest{
  # Update stations data frame
  if(requireNamespace("lutz") && requireNamespace("sf")) {
    s <- stations_dl()

    # Use new data frame to search for stations
    stations_search("Winnipeg", stn = s)
   }
}

}
