% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemspider.R
\name{cs_convert}
\alias{cs_convert}
\title{Convert identifiers using ChemSpider}
\usage{
cs_convert(query, from, to, verbose = getOption("verbose"), apikey = NULL)
}
\arguments{
\item{query}{character; query ID.}

\item{from}{character; type of query ID.}

\item{to}{character; type to convert to.}

\item{verbose}{logical; should a verbose output be printed on the console?}

\item{apikey}{character; your API key. If NULL (default),
\code{cs_check_key()} will look for it in .Renviron or .Rprofile.}
}
\value{
Returns a vector containing the converted identifier(s).
}
\description{
Submit one or more identifiers (CSID, SMILES, InChI, InChIKey or Mol) and
return one or more identifiers in another format (CSID, SMILES, InChI,
InChIKey or Mol).
}
\details{
Not all conversions are supported. Allowed conversions:
\itemize{
\item CSID <-> InChI
\item CSID <-> InChIKey
\item CSID <-> SMILES
\item CSID -> Mol file
\item InChI <-> InChIKey
\item InChI <-> SMILES
\item InChI -> Mol file
\item InChIKey <-> Mol file
}
}
\note{
An API key is needed. Register at \url{https://developer.rsc.org/}
for an API key. Please respect the Terms & Conditions. The Terms & Conditions
can be found at \url{https://developer.rsc.org/terms}.
}
\examples{
\dontrun{
cs_convert("BQJCRHHNABKAKU-KBQPJGBKSA-N",
  from = "inchikey", to = "csid"
)
cs_convert("BQJCRHHNABKAKU-KBQPJGBKSA-N",
  from = "inchikey", to = "inchi"
)
cs_convert("BQJCRHHNABKAKU-KBQPJGBKSA-N",
  from = "inchikey", to = "mol"
)
cs_convert(160, from = "csid", to = "smiles")
}
}
\references{
\url{https://developer.rsc.org/docs/compounds-v1-trial/1/overview}

Eduard Szöcs, Tamás Stirling, Eric R. Scott, Andreas Scharmüller,
Ralf B. Schäfer (2020). webchem: An R Package to Retrieve Chemical
Information from the Web. Journal of Statistical Software, 93(13).
\doi{10.18637/jss.v093.i13}.
}
