% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tem.R
\name{features}
\alias{features}
\title{Feature Points}
\usage{
features(..., tem_id = c("frl", "dlib70"))
}
\arguments{
\item{...}{a vector of feature names (see Details)}

\item{tem_id}{template ID (currently only works for frl and dlib70)}
}
\value{
vector of corresponding template indices
}
\description{
Get point indices for features, usually for use with \code{\link{subset_tem}}.
}
\details{
Available features for the frl template are: "gmm", "oval", "face", "mouth", "nose", "eyes", "brows", "left_eye", "right_eye", "left_brow",  "right_brow", "ears", "undereyes", "teeth", "smile_lines", "cheekbones", "philtrum", "chin", "neck", "halo".

Available features for the dlib70 template are: "teeth", "left_eye", "right_eye", "left_brow", "right_brow", "nose", "mouth", "face".
}
\examples{
features("mouth")
features("gmm")
features("nose", tem_id = "dlib70")

}
\seealso{
Template functions
\code{\link{auto_delin}()},
\code{\link{average_tem}()},
\code{\link{centroid}()},
\code{\link{change_lines}()},
\code{\link{delin}()},
\code{\link{draw_tem}()},
\code{\link{get_point}()},
\code{\link{remove_tem}()},
\code{\link{require_tems}()},
\code{\link{same_tems}()},
\code{\link{squash_tem}()},
\code{\link{subset_tem}()},
\code{\link{tem_def}()},
\code{\link{viz_tem_def}()}
}
\concept{tem}
