% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotate.R
\name{rotate}
\alias{rotate}
\title{Rotate templates and images}
\usage{
rotate(
  stimuli,
  degrees = 0,
  fill = wm_opts("fill"),
  keep_size = TRUE,
  origin = "image"
)
}
\arguments{
\item{stimuli}{list of stimuli}

\item{degrees}{degrees to rotate}

\item{fill}{background color, see \code{\link[=color_conv]{color_conv()}}}

\item{keep_size}{whether to keep the original size or expand images to the new rotated size}

\item{origin}{The origin of the rotation. Options are:
\code{"image"} will rotate around the image center.

\code{"tem"} will rotate around the average of all template coordinates.

A vector of 1 or more point indices (0-based) will rotate around their average position.}
}
\value{
list of stimuli with rotated tems and/or images
}
\description{
Rotate templates and images
}
\examples{
stimuli <- demo_stim() |> resize(0.5)

rotate(stimuli, 45, fill = "dodgerblue")
rotate(stimuli, 45, fill = "dodgerblue", keep_size = FALSE)
  
\donttest{
# if images are not in the centre of the image,
# try setting the origin to tem or specific point(s)
offset <- stimuli[1] |> 
  draw_tem() |> 
  pad(0, 250, 0, 0, fill = "dodgerblue")
  
rotate(offset, 45, origin = "image", fill = "pink")
rotate(offset, 45, origin = "tem", fill = "pink")

# rotate around point 0 (left eye)
offset |> crop_tem() |> rep(8) |>
  rotate(seq(0, 325, 45), origin = 0, fill = "pink") |>
  animate(fps = 5)
}

}
\seealso{
Stimulus manipulation functions
\code{\link{align}()},
\code{\link{crop_tem}()},
\code{\link{crop}()},
\code{\link{greyscale}()},
\code{\link{horiz_eyes}()},
\code{\link{image_func}()},
\code{\link{mask_oval}()},
\code{\link{mask}()},
\code{\link{mirror}()},
\code{\link{pad}()},
\code{\link{resize}()},
\code{\link{to_size}()}
}
\concept{manipulators}
