% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readers.R
\name{read_clf}
\alias{read_clf}
\title{read CLF-formatted logs}
\usage{
read_clf(file, has_header = FALSE)
}
\arguments{
\item{file}{the full path to the CLF-formatted file you want to read.}

\item{has_header}{whether or not the file has a header row. Set to FALSE by
default.}
}
\value{
a data.frame consisting of seven fields, as discussed above, with normalised
timestamps.
}
\description{
Read a file of request logs stored in the
\href{https://en.wikipedia.org/wiki/Common_Log_Format}{Common Log Format}.
}
\details{
the CLF is a standardised format for web request logs. It consists of the fields:

\itemize{
 \item{ip_address:} {the IP address of the remote host that made the request. The CLF
 does not (by default) include the de-facto standard X-Forwarded-For header}
 \item{remote_user_ident:} {the \href{https://tools.ietf.org/html/rfc1413}{RFC 1413} remote
 user identifier.}
 \item{local_user_ident:} {the identifier the user has authenticated with locally.}
 \item{timestamp:} {the timestamp associated with the request, stored as
 "[08/Apr/2001:17:39:04 -0800]", where "-0800" represents the time offset (minus
 eight hours) of the timestamp from UTC.}
 \item{request:} {the actual user request, containing the HTTP method used, the
 asset requested, and the HTTP Protocol version used.}
 \item{status_code:} {the HTTP status code returned.}
 \item{bytes_sent:} {the number of bytes sent}
}

While outdated as a standard, systems using the CLF are still around; the Squid caching
system, for example, uses the CLF as one of its default log formats (the other,
the squid "native" format, can be read with \code{\link{read_squid}}).
}
\examples{
#Read in an example CLF-formatted file provided with the webreadr package.
data <- read_clf(system.file("extdata/log.clf", package = "webreadr"))
}
\seealso{
\code{\link{read_combined}} for the /Combined/ Log Format, and
\code{\link{split_clf}} for splitting out the "requests" field.
}

